//
// C++ Interface:
//
// Description:
//
//
// Author: Sebastian Holtermann <sebholt@xwmw.org>, (C) 2011
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef __INC_mv_mixer_ctl_hpp__
#define __INC_mv_mixer_ctl_hpp__

#include <mview/mv_base.hpp>

#include <QTableView>
#include <QStackedLayout>


// Forward declaration
namespace QSnd {
	class Mixer_CTL;
}
namespace Wdg {
	class Tree_View_KV;
}
namespace MWdg {
	class Mixer_CTL_Tree_Model;
	class Mixer_CTL_Table_Model;
	class Mixer_CTL;
}
namespace MView {
	class MV_Mixer_CTL_Setup;
}


namespace MView
{


class MV_Mixer_CTL :
	public ::MView::MV_Base
{
	Q_OBJECT

	// Public methods
	public:

	MV_Mixer_CTL (
		QWidget * parent_n = 0 );

	~MV_Mixer_CTL ( );


	// Mixer device and view setup

	void
	set_mdev_setup (
		const ::MWdg::Mixer_Device_Setup * setup_n );

	void
	set_inputs_setup (
		const ::MWdg::Inputs_Setup * setup_n );

	void
	set_view_setup (
		::MView::MV_Base_Setup * setup_n );


	// Protected slots
	protected slots:

	void
	tree_element_selected (
		const QModelIndex & idx_n );

	void
	table_element_selected (
		const QModelIndex & idx_n );


	// Protected methods
	protected:

	void
	setup_view ( );

	void
	expand_tree_items ( );

	void
	adjust_table_columns ( );


	void
	restore_state ( );


	// Private attributes
	private:

	::MView::MV_Mixer_CTL_Setup * _view_setup;

	// Databases
	::QSnd::Mixer_CTL * _snd_mixer;
	::MWdg::Mixer_CTL_Tree_Model * _tree_model;
	::MWdg::Mixer_CTL_Table_Model * _table_model;

	// Side widgets
	QWidget _wdg_side;
	::Wdg::Tree_View_KV * _tree_view;

	// Central widgets
	QWidget _wdg_center;
	QStackedLayout * _lay_center_stack;
	QTableView * _table_view;
	::MWdg::Mixer_CTL * _mixer_ctl;

	unsigned int _default_iface_type_idx;
};


} // End of namespace


#endif
