//
// C++ Implementation:
//
// Description:
//
//
// Author: Sebastian Holtermann <sebholt@xwmw.org>, (C) 2011
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "mv_base.hpp"

#include <mwdg/mixer_device_setup.hpp>
#include <mview/message_widget.hpp>

#include <iostream>


namespace MView
{


MV_Base::MV_Base (
	QWidget * parent_n ) :
QWidget ( parent_n )
{
	_message_wdg = new ::MView::Message_Widget ( this );
	_message_wdg->hide();
	QStackedLayout * lay ( new QStackedLayout ( this ) );
	lay->setContentsMargins ( 0, 0, 0, 0 );
	lay->addWidget ( _message_wdg );
}


MV_Base::~MV_Base ( )
{
}


void
MV_Base::set_mdev_setup (
	const ::MWdg::Mixer_Device_Setup * setup_n )
{
	//::std::cout << "MV_Base::set_mdev_setup: " << setup_n << "\n";
	_mdev_setup = setup_n;
}


void
MV_Base::set_inputs_setup (
	const ::MWdg::Inputs_Setup * setup_n )
{
	//::std::cout << "MV_Base::set_inputs_setup: " << setup_n << "\n";
	_inputs_setup = setup_n;
}


} // End of namespace
