//
// C++ Implementation:
//
// Description:
//
//
// Author: Sebastian Holtermann <sebholt@xwmw.org>, (C) 2011
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "dev_select_view.hpp"

#include <mview/dev_select_view_setup.hpp>
#include <mwdg/controls_model.hpp>
#include <mwdg/controls_view.hpp>

#include <QLabel>
#include <QVBoxLayout>
#include <QMenu>
#include <QContextMenuEvent>

#include <iostream>


namespace MView
{


Dev_Select_View::Dev_Select_View (
	QWidget * parent_n ) :
QWidget ( parent_n ),
_view_setup ( 0 )
{
	_act_close = new QAction ( this );
	if ( QIcon::hasThemeIcon ( "window-close" ) ) {
		_act_close->setIcon ( QIcon::fromTheme ( "window-close" ) );
	}
	_act_close->setText ( tr ( "&Close device selection" ) );
	connect ( _act_close, SIGNAL ( triggered ( bool ) ),
		this, SIGNAL ( sig_close() ) );

	// Control selection tree view
	{
		_controls_view = new ::MWdg::Controls_View;
		_controls_model = new ::MWdg::Controls_Model;

		_controls_view->setHorizontalScrollBarPolicy ( Qt::ScrollBarAlwaysOff );
		_controls_view->setModel ( _controls_model );

		connect ( _controls_view, SIGNAL ( activated ( const QModelIndex & ) ),
			this, SLOT ( control_selected ( const QModelIndex & ) ) );

		connect ( _controls_model, SIGNAL ( modelReset() ),
			this, SLOT ( restore_selected_ctl() ) );
	}

	{
		QSizePolicy policy ( sizePolicy() );
		policy.setHorizontalPolicy ( QSizePolicy::Preferred );
		policy.setVerticalPolicy ( QSizePolicy::Expanding );
		setSizePolicy ( policy );
	}

	{
		QVBoxLayout * lay_vbox ( new QVBoxLayout() );
		lay_vbox->addWidget ( _controls_view, 1 );
		lay_vbox->addStretch ( 0 );
		setLayout ( lay_vbox );
	}
}


Dev_Select_View::~Dev_Select_View ( )
{
	_controls_view->setModel ( 0 );
	delete _controls_model;
	delete _controls_view;
}


void
Dev_Select_View::set_view_setup (
	::MView::Dev_Select_View_Setup * setup_n )
{
	if ( _view_setup != 0 ) {
		_controls_view->set_view_setup ( 0 );
		_controls_model->set_alsa_cfg_model ( 0 );
	}

	_view_setup = setup_n;

	if ( _view_setup != 0 ) {
		if ( _view_setup->alsa_cfg_model != 0 ) {
			_controls_model->set_alsa_cfg_model (
				_view_setup->alsa_cfg_model );
		}
		_controls_view->set_view_setup ( &_view_setup->ctl_view );
	}
}


void
Dev_Select_View::update_selected_ctl (
	const ::QSnd::Control_Address & ctl_n )
{
	QModelIndex midx (
		_controls_model->ctl_info_index ( ctl_n ) );

	_controls_view->blockSignals ( true );
	_controls_view->setCurrentIndex ( midx );
	_controls_view->blockSignals ( false );

	if ( midx.isValid() ) {
		_selected_ctl = *_controls_model->ctl_info ( midx );
	} else {
		_selected_ctl.clear();
	}
}


void
Dev_Select_View::control_selected (
	const QModelIndex & idx_n )
{
	const ::QSnd::Control_Address * ctl_info ( 0 );

	//std::cout << "Dev_Select_View::control_selected " << "\n";

	if ( idx_n.isValid() && ( _controls_view->model() != 0 ) ) {
		ctl_info = _controls_model->ctl_info ( idx_n );
	}

	if ( ctl_info != 0 ) {
		if ( _selected_ctl != (*ctl_info) ) {
			_selected_ctl = *ctl_info;
			emit sig_control_changed();
		}
	}

}


void
Dev_Select_View::reload_devices_list ( )
{
	//std::cout << "Dev_Select_View::reload_devices_list" << "\n";

	if ( _view_setup != 0 ) {
		if ( _view_setup->alsa_cfg_model != 0 ) {
			_view_setup->alsa_cfg_model->revert();
		}
	}
}


void
Dev_Select_View::restore_selected_ctl ( )
{
	QModelIndex midx (
		_controls_model->ctl_info_index ( _selected_ctl ) );
	_controls_view->setCurrentIndex ( midx );
}


void
Dev_Select_View::contextMenuEvent (
	QContextMenuEvent * event_n )
{
	QMenu cmenu ( this );
	cmenu.addAction ( _act_close );
	cmenu.exec ( event_n->globalPos() );
}


} // End of namespace

