//
// C++ Implementation:
//
// Description:
//
//
// Author: Sebastian Holtermann <sebholt@xwmw.org>, (C) 2011
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include <iostream>

#include <QTranslator>
#include <QLocale>
#include <QLibraryInfo>
#include <QDesktopWidget>
#include <QString>
#include <QFile>
#include <QFileInfo>
#include <QIcon>
#include <QApplication>

#include "main_window.hpp"
#include "config.hpp"


/// @brief The main function
///
int
main (
	int argc,
	char * argv[] )
{

	// QT Application

	QApplication app ( argc, argv );
	app.setOrganizationName ( QString ( PROGRAM_NAME ).toLower() );
	app.setApplicationName ( PROGRAM_NAME );
	app.setAttribute ( Qt::AA_DontShowIconsInMenus, false );

	// Application icon setup
	{
		QIcon icon;
		{
			// Try application icon
			QString icon_path ( INSTALL_DIR_ICONS_SVG );
			icon_path += "/";
			icon_path += PROGRAM_NAME;
			icon_path += ".svg";

			QFileInfo finfo ( icon_path );
			if ( finfo.exists() && finfo.isReadable() ) {
				icon = QIcon ( icon_path );
			}
		}
		if ( icon.isNull() ) {
			// Try system theme icon
			const QString iname ( "multimedia-volume-control" );
			if ( QIcon::hasThemeIcon ( iname  ) ) {
				icon = QIcon::fromTheme ( iname  );
			}
		}
		if ( !icon.isNull() ) {
			app.setWindowIcon ( icon );
		}
	}

	// Application translators setup
	{
		QTranslator * trans_qt ( new QTranslator ( &app ) );
		QTranslator * trans_local ( new QTranslator ( &app ) );
		{
			trans_qt->load ( "qt_" + QLocale::system().name(),
				QLibraryInfo::location ( QLibraryInfo::TranslationsPath ) );

			trans_local->load ( "app_" + QLocale::system().name(),
				INSTALL_DIR_L10N );

			app.installTranslator ( trans_qt );
			app.installTranslator ( trans_local );
		}
	}

	Main_Window mwin;

	// Restore mixer window state
	bool size_restored = false;
	//size_restored =  mwin->restoreGeometry (
	//	_dsetup.mixer_window.window_geometry );

	// Adjust startup size
	if ( !size_restored ) {
		const QSize default_size ( 800, 450 );
		const QRect ravail ( QApplication::desktop()->availableGeometry() );

		if ( ravail.isValid() ) {

			const unsigned int aspect[2] = { 16, 9 };
			unsigned int rel_width[2];
			if ( ravail.width() > 1024 ) {
				// Larger screens
				rel_width[0] = 2;
				rel_width[1] = 3;
			} else {
				// Small screens - occupy more relative space
				rel_width[0] = 3;
				rel_width[1] = 4;
			}

			QRect wrect;
			wrect.setWidth ( ( ravail.width() * rel_width[0] ) / rel_width[1] );
			wrect.setHeight ( ( wrect.width() * aspect[1] ) / aspect[0] );
			if ( wrect.height() > ravail.height() ) {
				wrect.setHeight ( ravail.height() );
			}
			wrect.moveTop ( ( ravail.height() - wrect.height() ) / 2 );
			wrect.moveLeft ( ( ravail.width() - wrect.width() ) / 2 );
			mwin.resize ( wrect.size() );
			mwin.move ( wrect.topLeft() );
		} else {
			mwin.resize ( default_size );
		}
	}

	mwin.show();

	return app.exec();
}

