//
// C++ Interface:
//
// Description:
//
//
// Author: Sebastian Holtermann <sebholt@xwmw.org>, (C) 2011
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef __INC_alsa_config_view_hpp__
#define __INC_alsa_config_view_hpp__

#include <QPushButton>
#include <QCheckBox>
#include <QSpinBox>
#include <QModelIndex>
#include <QStringList>


// Forward declaration
class QAbstractItemModel;
class QSortFilterProxyModel;
class QItemSelection;
class Tree_View_KV;
class Alsa_Config_Model;


class Alsa_Config_View :
	public QWidget
{
	Q_OBJECT

	// Public methods
	public:

	Alsa_Config_View (
		QWidget * parent_n = 0 );

	~Alsa_Config_View ( );


	Alsa_Config_Model *
	model ( ) const;

	void
	set_model (
		Alsa_Config_Model * model_n );



	// Public slots
	public slots:

	void
	reload_config ( );

	void
	expand_to_level (
		bool expanded_n );

	void
	expand_to_level ( );

	void
	collapse_to_level ( );

	void
	enable_sorting (
		bool flag_n );


	// Protected slots
	protected slots:

	void
	items_selected (
		const QItemSelection & sel0_n,
		const QItemSelection & sel1_n );


	// Protected methods
	protected:

	void
	collect_expanded (
		QStringList & lst_n,
		const QModelIndex & = QModelIndex() );

	void
	set_expanded (
		QStringList & lst_n );

	void
	update_button_state ( );


	// Private attributes
	private:

	Alsa_Config_Model * _alsa_cfg;
	QSortFilterProxyModel * _sort_model;

	// Widgets
	Tree_View_KV * _tree_view;
	QPushButton _btn_expand;
	QPushButton _btn_collapse;
	QCheckBox _btn_sort;
	QSpinBox _expand_depth;
};


inline
Alsa_Config_Model *
Alsa_Config_View::model ( ) const
{
	return _alsa_cfg;
}


#endif
