/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.util.LinkedList;
import java.util.List;
import jline.Completor;
import jline.ConsoleReader;

public class ArgumentCompletor
implements Completor {
    final Completor[] completors;
    final ArgumentDelimiter delim;
    boolean strict = true;

    public ArgumentCompletor(Completor completor) {
        this(new Completor[]{completor});
    }

    public ArgumentCompletor(List list) {
        this(list.toArray(new Completor[list.size()]));
    }

    public ArgumentCompletor(Completor[] completorArray) {
        this(completorArray, (ArgumentDelimiter)new WhitespaceArgumentDelimiter());
    }

    public ArgumentCompletor(Completor completor, ArgumentDelimiter argumentDelimiter) {
        this(new Completor[]{completor}, argumentDelimiter);
    }

    public ArgumentCompletor(Completor[] completorArray, ArgumentDelimiter argumentDelimiter) {
        this.completors = completorArray;
        this.delim = argumentDelimiter;
    }

    public void setStrict(boolean bl) {
        this.strict = bl;
    }

    public boolean getStrict() {
        return this.strict;
    }

    public int complete(String string, int n, List list) {
        String string2;
        int n2;
        ArgumentList argumentList = this.delim.delimit(string, n);
        int n3 = argumentList.getArgumentPosition();
        int n4 = argumentList.getCursorArgumentIndex();
        if (n4 < 0) {
            return -1;
        }
        Completor completor = n4 >= this.completors.length ? this.completors[this.completors.length - 1] : this.completors[n4];
        for (n2 = 0; this.getStrict() && n2 < n4; ++n2) {
            Completor completor2 = this.completors[n2 >= this.completors.length ? this.completors.length - 1 : n2];
            String[] stringArray = argumentList.getArguments();
            string2 = stringArray == null || n2 >= stringArray.length ? "" : stringArray[n2];
            LinkedList linkedList = new LinkedList();
            if (completor2.complete(string2, string2.length(), linkedList) == -1) {
                return -1;
            }
            if (linkedList.size() != 0) continue;
            return -1;
        }
        n2 = completor.complete(argumentList.getCursorArgument(), n3, list);
        if (n2 == -1) {
            return -1;
        }
        int n5 = n2 + (argumentList.getBufferPosition() - n3) + 1;
        if (n != string.length() && this.delim.isDelimiter(string, n)) {
            for (int i = 0; i < list.size(); ++i) {
                string2 = list.get(i).toString();
                while (string2.length() > 0 && this.delim.isDelimiter(string2, string2.length() - 1)) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                list.set(i, string2);
            }
        }
        ConsoleReader.debug("Completing " + string + "(pos=" + n + ") " + "with: " + list + ": offset=" + n5);
        return n5;
    }

    public static class ArgumentList {
        private String[] arguments;
        private int cursorArgumentIndex;
        private int argumentPosition;
        private int bufferPosition;

        public ArgumentList(String[] stringArray, int n, int n2, int n3) {
            this.arguments = stringArray;
            this.cursorArgumentIndex = n;
            this.argumentPosition = n2;
            this.bufferPosition = n3;
        }

        public void setCursorArgumentIndex(int n) {
            this.cursorArgumentIndex = n;
        }

        public int getCursorArgumentIndex() {
            return this.cursorArgumentIndex;
        }

        public String getCursorArgument() {
            if (this.cursorArgumentIndex < 0 || this.cursorArgumentIndex >= this.arguments.length) {
                return null;
            }
            return this.arguments[this.cursorArgumentIndex];
        }

        public void setArgumentPosition(int n) {
            this.argumentPosition = n;
        }

        public int getArgumentPosition() {
            return this.argumentPosition;
        }

        public void setArguments(String[] stringArray) {
            this.arguments = stringArray;
        }

        public String[] getArguments() {
            return this.arguments;
        }

        public void setBufferPosition(int n) {
            this.bufferPosition = n;
        }

        public int getBufferPosition() {
            return this.bufferPosition;
        }
    }

    public static class WhitespaceArgumentDelimiter
    extends AbstractArgumentDelimiter {
        public boolean isDelimiterChar(String string, int n) {
            return Character.isWhitespace(string.charAt(n));
        }
    }

    public static abstract class AbstractArgumentDelimiter
    implements ArgumentDelimiter {
        private char[] quoteChars = new char[]{'\'', '\"'};
        private char[] escapeChars = new char[]{'\\'};

        public void setQuoteChars(char[] cArray) {
            this.quoteChars = cArray;
        }

        public char[] getQuoteChars() {
            return this.quoteChars;
        }

        public void setEscapeChars(char[] cArray) {
            this.escapeChars = cArray;
        }

        public char[] getEscapeChars() {
            return this.escapeChars;
        }

        public ArgumentList delimit(String string, int n) {
            LinkedList<String> linkedList = new LinkedList<String>();
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = -1;
            int n3 = -1;
            for (int i = 0; string != null && i <= string.length(); ++i) {
                if (i == n) {
                    n3 = linkedList.size();
                    n2 = stringBuffer.length();
                }
                if (i == string.length() || this.isDelimiter(string, i)) {
                    if (stringBuffer.length() <= 0) continue;
                    linkedList.add(stringBuffer.toString());
                    stringBuffer.setLength(0);
                    continue;
                }
                stringBuffer.append(string.charAt(i));
            }
            return new ArgumentList(linkedList.toArray(new String[linkedList.size()]), n3, n2, n);
        }

        public boolean isDelimiter(String string, int n) {
            if (this.isQuoted(string, n)) {
                return false;
            }
            if (this.isEscaped(string, n)) {
                return false;
            }
            return this.isDelimiterChar(string, n);
        }

        public boolean isQuoted(String string, int n) {
            return false;
        }

        public boolean isEscaped(String string, int n) {
            if (n <= 0) {
                return false;
            }
            for (int i = 0; this.escapeChars != null && i < this.escapeChars.length; ++i) {
                if (string.charAt(n) != this.escapeChars[i]) continue;
                return !this.isEscaped(string, n - 1);
            }
            return false;
        }

        public abstract boolean isDelimiterChar(String var1, int var2);
    }

    public static interface ArgumentDelimiter {
        public ArgumentList delimit(String var1, int var2);

        public boolean isDelimiter(String var1, int var2);
    }
}

