# Traitement de certaines tables africaines.
# Copyright  1999, 2000, 2002 Progiciels Bourbeau-Pinard inc.
# Franois Pinard <pinard@iro.umontreal.ca>, 1997.  */

import recode

declares = [
    ('BPI-101', 'AFRL1-101-BPI_OCIL', 't-latin1', 't-francais', 't-fra'),
    ('BPI-103', 'AFRFUL-103-BPI_OCIL',
     't-bpi102', 't-bambara', 't-bra', 't-ewondo', 't-fulfulde'),
    ('BPI-105', 'AFRLIN-105-BPI_OCIL',
     't-bpi104', 't-lingala', 't-lin', 't-sango', 't-wolof'),
    ('BPI-107', 't-bpi106'),
    ('BPI-109', 't-bpi108'),
    ('BPI-111', 't-bpi110'),
    ('BPI-113', 't-bpi112'),
    ]

class BPI_101(recode.GenericStep):
    internal_coding = 'ISO-8859-1'
    external_coding = 'BPI-101'
    data = [
        (160, '/_'),
        (161, '!<'),
        (162, '_Ct'),
        (163, '_Pd'),
        (164, '_Cu'),
        (165, '_Ye'),
        (166, '_BB'),
        (167, '_SE'),
        (168, '/\\"'),
        (169, '_Co'),
        (170, '_Fo'),
        (171, '<<'),
        (172, '_NO'),
        (173, '\\-'),
        (174, '_Rg'),
        (175, '/\\='),
        (176, '_DG'),
        (177, '_+-'),
        (178, '2^'),
        (179, '3^'),
        (180, '/\\\''),
        (181, '_My'),
        (182, '_PI'),
        (183, '_MD'),
        (184, '/\\,'),
        (185, '1^'),
        (186, '_Mo'),
        (187, '>>'),
        (188, '_14'),
        (189, '_12'),
        (190, '_34'),
        (191, '?<'),
        (192, 'A`'),
        (193, 'A\\\''),
        (194, 'A^'),
        (195, 'A~'),
        (196, 'A"'),
        (197, 'A\\R'),
        (198, 'AE+'),
        (199, 'C\\,'),
        (200, 'E`'),
        (201, 'E\\\''),
        (202, 'E^'),
        (203, 'E"'),
        (204, 'I`'),
        (205, 'I\\\''),
        (206, 'I^'),
        (207, 'I"'),
        (208, 'D\\x'),
        (209, 'N~'),
        (210, 'O`'),
        (211, 'O\\\''),
        (212, 'O^'),
        (213, 'O~'),
        (214, 'O"'),
        (215, '_Xs'),
        (216, 'O\\X'),
        (217, 'U`'),
        (218, 'U\\\''),
        (219, 'U^'),
        (220, 'U"'),
        (221, 'Y\\\''),
        (222, '_TH'),
        (223, 'ss+'),
        (224, 'a`'),
        (225, 'a\\\''),
        (226, 'a^'),
        (227, 'a~'),
        (228, 'a"'),
        (229, 'a\\R'),
        (230, 'ae+'),
        (231, 'c\\,'),
        (232, 'e`'),
        (233, 'e\\\''),
        (234, 'e^'),
        (235, 'e"'),
        (236, 'i`'),
        (237, 'i\\\''),
        (238, 'i^'),
        (239, 'i"'),
        (240, 'd\\x'),
        (241, 'n~'),
        (242, 'o`'),
        (243, 'o\\\''),
        (244, 'o^'),
        (245, 'o~'),
        (246, 'o"'),
        (247, '_Ds'),
        (248, 'o\\X'),
        (249, 'u`'),
        (250, 'u\\\''),
        (251, 'u^'),
        (252, 'u"'),
        (253, 'y\\\''),
        (254, '_th'),
        (255, 'y"'),
        ]

class BPI_103(recode.GenericStep):
    internal_coding = 'BPI-102'
    external_coding = 'BPI-103'
    data = [
        (160, '/_'),
        (161, 'B['),
        (162, 'D['),
        (163, 'G]'),
        (164, 'K['),
        (165, 'P['),
        (166, 'T['),
        (167, 'S]'),
        (168, 'N]'),
        (169, 'N['),
        (170, 'D]'),
        (171, '<<'),
        (172, 'F]'),
        (173, '\\-'),
        (174, 'Y['),
        (175, 'G['),
        (176, '_DG'),
        (177, 'b['),
        (178, 'd['),
        (179, 'g]'),
        (180, 'k['),
        (181, 'p['),
        (182, 't['),
        (183, 's]'),
        (184, 'n]'),
        (185, 'n['),
        (186, 'd]'),
        (187, '>>'),
        (188, 'f]'),
        (189, '?^'),
        (190, 'y['),
        (191, 'g['),
        (192, 'A`'),
        (193, 'A\\\''),
        (194, 'A^'),
        (195, 'A~'),
        (196, 'A"'),
        (197, 'E<'),
        (198, 'AE+'),
        (199, 'C\\,'),
        (200, 'E`'),
        (201, 'E\\\''),
        (202, 'E^'),
        (203, 'E"'),
        (204, 'I`'),
        (205, 'I\\\''),
        (206, 'I^'),
        (207, 'I"'),
        (208, 'E['),
        (209, 'N~'),
        (210, 'O`'),
        (211, 'O\\\''),
        (212, 'O^'),
        (213, 'O~'),
        (214, 'O"'),
        (215, 'OE+'),
        (216, 'O['),
        (217, 'U`'),
        (218, 'U\\\''),
        (219, 'U^'),
        (220, 'U"'),
        (221, 'E<\''),
        (222, 'O[\''),
        (223, 'V['),
        (224, 'a`'),
        (225, 'a\\\''),
        (226, 'a^'),
        (227, 'a~'),
        (228, 'a"'),
        (229, 'e<'),
        (230, 'ae+'),
        (231, 'c\\,'),
        (232, 'e`'),
        (233, 'e\\\''),
        (234, 'e^'),
        (235, 'e"'),
        (236, 'i`'),
        (237, 'i\\\''),
        (238, 'i^'),
        (239, 'i"'),
        (240, 'e['),
        (241, 'n~'),
        (242, 'o`'),
        (243, 'o\\\''),
        (244, 'o^'),
        (245, 'o~'),
        (246, 'o"'),
        (247, 'oe+'),
        (248, 'o['),
        (249, 'u`'),
        (250, 'u\\\''),
        (251, 'u^'),
        (252, 'u"'),
        (253, 'e<\''),
        (254, 'o[\''),
        (255, 'v['),
        ]

class BPI_105(recode.GenericStep):
    internal_coding = 'BPI-104'
    external_coding = 'BPI-105'
    data = [
        (160, '/_'),
        (161, 'E[`'),
        (162, 'E[\''),
        (163, 'E[^'),
        (164, 'E[\\v'),
        (165, 'O[`'),
        (166, 'O[\''),
        (167, 'O[^'),
        (168, 'N]'),
        (169, 'N['),
        (170, 'N^'),
        (171, '<<'),
        (172, 'N"'),
        (173, '\\-'),
        (174, 'Y['),
        (175, 'O[\\v'),
        (176, '_DG'),
        (177, 'e[`'),
        (178, 'e[\''),
        (179, 'e[^'),
        (180, 'e[\\v'),
        (181, 'o[`'),
        (182, 'o[\''),
        (183, 'o[^'),
        (184, 'n]'),
        (185, 'n['),
        (186, 'n^'),
        (187, '>>'),
        (188, 'n"'),
        (189, '?^'),
        (190, 'y['),
        (191, 'o[\\v'),
        (192, 'A`'),
        (193, 'A\\\''),
        (194, 'A^'),
        (195, 'A\\v'),
        (196, 'A"'),
        (197, 'E<'),
        (198, 'AE+'),
        (199, 'C\\,'),
        (200, 'E`'),
        (201, 'E\\\''),
        (202, 'E^'),
        (203, 'E"'),
        (204, 'I`'),
        (205, 'I\\\''),
        (206, 'I^'),
        (207, 'I"'),
        (208, 'E['),
        (209, 'N~'),
        (210, 'O`'),
        (211, 'O\\\''),
        (212, 'O^'),
        (213, 'O\\v'),
        (214, 'O"'),
        (215, 'OE+'),
        (216, 'O['),
        (217, 'U`'),
        (218, 'U\\\''),
        (219, 'U^'),
        (220, 'U"'),
        (221, 'E\\v'),
        (222, 'I\\v'),
        (223, 'U\\v'),
        (224, 'a`'),
        (225, 'a\\\''),
        (226, 'a^'),
        (227, 'a\\v'),
        (228, 'a"'),
        (229, 'e<'),
        (230, 'ae+'),
        (231, 'c\\,'),
        (232, 'e`'),
        (233, 'e\\\''),
        (234, 'e^'),
        (235, 'e"'),
        (236, 'i`'),
        (237, 'i\\\''),
        (238, 'i^'),
        (239, 'i"'),
        (240, 'e['),
        (241, 'n~'),
        (242, 'o`'),
        (243, 'o\\\''),
        (244, 'o^'),
        (245, 'o\\v'),
        (246, 'o"'),
        (247, 'oe+'),
        (248, 'o['),
        (249, 'u`'),
        (250, 'u\\\''),
        (251, 'u^'),
        (252, 'u"'),
        (253, 'e\\v'),
        (254, 'i\\v'),
        (255, 'u\\v'),
        ]

class BPI_107(recode.GenericStep):
    internal_coding = 'BPI-106'
    external_coding = 'BPI-107'
    data = [
        (160, '/_'),
        (161, 'P['),
        (162, 'T['),
        (163, 'K['),
        (164, 'B['),
        (165, 'D['),
        (166, 'S\\v'),
        (167, 'G]'),
        (168, 's\\v'),
        (169, 'N]'),
        (170, 'N['),
        (171, '<<'),
        (172, '?^'),
        (173, '\\-'),
        (174, 'F]'),
        (175, 'C['),
        (176, '_DG'),
        (177, 'p['),
        (178, 't['),
        (179, 'k['),
        (180, 'b['),
        (181, 'd['),
        (182, '_PI'),
        (183, '_MD'),
        (184, 'g]'),
        (185, 'n]'),
        (186, 'n['),
        (187, '>>'),
        (188, 'OE+'),
        (189, 'oe+'),
        (190, 'f]'),
        (191, 'c['),
        (192, 'A`'),
        (193, 'A\\\''),
        (194, 'A^'),
        (195, 'T]'),
        (196, 'Y['),
        (197, 'E['),
        (198, 'AE+'),
        (199, 'C\\,'),
        (200, 'E`'),
        (201, 'E\\\''),
        (202, 'E^'),
        (203, 'E"'),
        (204, 'I`'),
        (205, 'I\\\''),
        (206, 'I^'),
        (207, 'I"'),
        (208, 'D]'),
        (209, 'N~'),
        (210, 'O`'),
        (211, 'O\\\''),
        (212, 'O^'),
        (213, 'E<'),
        (214, 'G['),
        (215, '_Xs'),
        (216, 'O['),
        (217, 'U`'),
        (218, 'U\\\''),
        (219, 'U^'),
        (220, 'U"'),
        (221, 'V['),
        (222, 'S]'),
        (223, 'Z]'),
        (224, 'a`'),
        (225, 'a\\\''),
        (226, 'a^'),
        (227, 't]'),
        (228, 'y['),
        (229, 'e['),
        (230, 'ae+'),
        (231, 'c\\,'),
        (232, 'e`'),
        (233, 'e\\\''),
        (234, 'e^'),
        (235, 'e"'),
        (236, 'i`'),
        (237, 'i\\\''),
        (238, 'i^'),
        (239, 'i"'),
        (240, 'd]'),
        (241, 'n~'),
        (242, 'o`'),
        (243, 'o\\\''),
        (244, 'o^'),
        (245, 'e<'),
        (246, 'g['),
        (247, '_Ds'),
        (248, 'o['),
        (249, 'u`'),
        (250, 'u\\\''),
        (251, 'u^'),
        (252, 'u"'),
        (253, 'v['),
        (254, 's]'),
        (255, 'z]'),
        ]

class BPI_109(recode.GenericStep):
    internal_coding = 'BPI-108'
    external_coding = 'BPI-109'
    data = [
        (160, '/_'),
        (161, 'E[`'),
        (162, 'E[\''),
        (163, 'E[^'),
        (164, 'E[\\v'),
        (165, 'O[`'),
        (166, 'O[\''),
        (167, 'O[^'),
        (168, 'o[\''),
        (169, 'N]'),
        (170, 'N['),
        (171, '<<'),
        (172, 'Y['),
        (173, '\\-'),
        (174, 'o[^'),
        (175, 'O[\\v'),
        (176, '_DG'),
        (177, 'e[`'),
        (178, 'e[\''),
        (179, 'e[^'),
        (180, 'e[\\v'),
        (181, 'o[`'),
        (182, '_PI'),
        (183, 'y['),
        (184, 'E<\''),
        (185, 'n]'),
        (186, 'n['),
        (187, '>>'),
        (188, 'OE+'),
        (189, 'oe+'),
        (190, 'e<\''),
        (191, 'o[\\v'),
        (192, 'A`'),
        (193, 'A\\\''),
        (194, 'A^'),
        (195, 'A\\v'),
        (196, 'A"'),
        (197, 'E<'),
        (198, 'AE+'),
        (199, 'C\\,'),
        (200, 'E`'),
        (201, 'E\\\''),
        (202, 'E^'),
        (203, 'E"'),
        (204, 'I`'),
        (205, 'I\\\''),
        (206, 'I^'),
        (207, 'I"'),
        (208, 'E['),
        (209, 'N~'),
        (210, 'O`'),
        (211, 'O\\\''),
        (212, 'O^'),
        (213, 'O\\v'),
        (214, 'O"'),
        (215, '_Xs'),
        (216, 'O['),
        (217, 'U`'),
        (218, 'U\\\''),
        (219, 'U^'),
        (220, 'U"'),
        (221, 'E\\v'),
        (222, 'I\\v'),
        (223, 'U\\v'),
        (224, 'a`'),
        (225, 'a\\\''),
        (226, 'a^'),
        (227, 'a\\v'),
        (228, 'a"'),
        (229, 'e<'),
        (230, 'ae+'),
        (231, 'c\\,'),
        (232, 'e`'),
        (233, 'e\\\''),
        (234, 'e^'),
        (235, 'e"'),
        (236, 'i`'),
        (237, 'i\\\''),
        (238, 'i^'),
        (239, 'i"'),
        (240, 'e['),
        (241, 'n~'),
        (242, 'o`'),
        (243, 'o\\\''),
        (244, 'o^'),
        (245, 'o\\v'),
        (246, 'o"'),
        (247, '_Ds'),
        (248, 'o['),
        (249, 'u`'),
        (250, 'u\\\''),
        (251, 'u^'),
        (252, 'u"'),
        (253, 'e\\v'),
        (254, 'i\\v'),
        (255, 'u\\v'),
        ]

class BPI_111(recode.GenericStep):
    internal_coding = 'BPI-110'
    external_coding = 'BPI-111'
    data = [
        (160, '/_'),
        (161, 'E[`'),
        (162, 'E[\''),
        (163, 'E[^'),
        (164, 'E[\\v'),
        (165, 'O[`'),
        (166, 'O[\''),
        (167, 'O[^'),
        (168, 'o[\''),
        (169, 'N]'),
        (170, 'N['),
        (171, '<<'),
        (172, 'S\\v'),
        (173, '\\-'),
        (174, 'o[^'),
        (175, 'O[\\v'),
        (176, '_DG'),
        (177, 'e[`'),
        (178, 'e[\''),
        (179, 'e[^'),
        (180, 'e[\\v'),
        (181, 'o[`'),
        (182, '_PI'),
        (183, 's\\v'),
        (184, 'I~'),
        (185, 'n]'),
        (186, 'n['),
        (187, '>>'),
        (188, 'OE+'),
        (189, 'oe+'),
        (190, 'i~'),
        (191, 'o[\\v'),
        (192, 'A`'),
        (193, 'A\\\''),
        (194, 'A^'),
        (195, 'A~'),
        (196, 'A\\v'),
        (197, 'E~'),
        (198, 'AE+'),
        (199, 'C\\,'),
        (200, 'E`'),
        (201, 'E\\\''),
        (202, 'E^'),
        (203, 'E"'),
        (204, 'I`'),
        (205, 'I\\\''),
        (206, 'I^'),
        (207, 'I"'),
        (208, 'E['),
        (209, 'U~'),
        (210, 'O`'),
        (211, 'O\\\''),
        (212, 'O^'),
        (213, 'O~'),
        (214, 'O\\v'),
        (215, '_Xs'),
        (216, 'O['),
        (217, 'U`'),
        (218, 'U\\\''),
        (219, 'U^'),
        (220, 'U"'),
        (221, 'E\\v'),
        (222, 'I\\v'),
        (223, 'U\\v'),
        (224, 'a`'),
        (225, 'a\\\''),
        (226, 'a^'),
        (227, 'a~'),
        (228, 'a\\v'),
        (229, 'e~'),
        (230, 'ae+'),
        (231, 'c\\,'),
        (232, 'e`'),
        (233, 'e\\\''),
        (234, 'e^'),
        (235, 'e"'),
        (236, 'i`'),
        (237, 'i\\\''),
        (238, 'i^'),
        (239, 'i"'),
        (240, 'e['),
        (241, 'u~'),
        (242, 'o`'),
        (243, 'o\\\''),
        (244, 'o^'),
        (245, 'o~'),
        (246, 'o\\v'),
        (247, '_Ds'),
        (248, 'o['),
        (249, 'u`'),
        (250, 'u\\\''),
        (251, 'u^'),
        (252, 'u"'),
        (253, 'e\\v'),
        (254, 'i\\v'),
        (255, 'u\\v'),
        ]

class BPI_113(recode.GenericStep):
    internal_coding = 'BPI-112'
    external_coding = 'BPI-113'
    data = [
        (160, '/_'),
        (161, 'P['),
        (162, 'T\\d'),
        (163, 'K['),
        (164, 'B\\d'),
        (165, 'D\\d'),
        (166, 'S\\v'),
        (167, 'G]'),
        (168, 's\\v'),
        (169, 'N]'),
        (170, 'N['),
        (171, '<<'),
        (172, '?>'),
        (173, '\\-'),
        (174, 'H\\d'),
        (175, 'L\\d'),
        (176, '_DG'),
        (177, 'p['),
        (178, 't\\d'),
        (179, 'k['),
        (180, 'b\\d'),
        (181, 'd\\d'),
        (182, '_PI'),
        (183, '_MD'),
        (184, 'g]'),
        (185, 'n]'),
        (186, 'n['),
        (187, '>>'),
        (188, 'OE+'),
        (189, 'oe+'),
        (190, 'h\\d'),
        (191, 'l\\d'),
        (192, 'A`'),
        (193, 'A\\\''),
        (194, 'A^'),
        (195, 'A\\u'),
        (196, 'E<'),
        (197, 'E['),
        (198, 'AE+'),
        (199, 'C\\,'),
        (200, 'E`'),
        (201, 'E\\\''),
        (202, 'E^'),
        (203, 'E"'),
        (204, 'I`'),
        (205, 'I\\\''),
        (206, 'I^'),
        (207, 'I"'),
        (208, 'D]'),
        (209, 'N~'),
        (210, 'O`'),
        (211, 'O\\\''),
        (212, 'O^'),
        (213, 'S\\d'),
        (214, 'Z\\d'),
        (215, '_Xs'),
        (216, 'O['),
        (217, 'U`'),
        (218, 'U\\\''),
        (219, 'U^'),
        (220, 'U"'),
        (221, 'Z\\v'),
        (222, 'S]'),
        (223, 'Z]'),
        (224, 'a`'),
        (225, 'a\\\''),
        (226, 'a^'),
        (227, 'a\\u'),
        (228, 'e<'),
        (229, 'e['),
        (230, 'ae+'),
        (231, 'c\\,'),
        (232, 'e`'),
        (233, 'e\\\''),
        (234, 'e^'),
        (235, 'e"'),
        (236, 'i`'),
        (237, 'i\\\''),
        (238, 'i^'),
        (239, 'i"'),
        (240, 'd]'),
        (241, 'n~'),
        (242, 'o`'),
        (243, 'o\\\''),
        (244, 'o^'),
        (245, 's\\d'),
        (246, 'z\\d'),
        (247, '_Ds'),
        (248, 'o['),
        (249, 'u`'),
        (250, 'u\\\''),
        (251, 'u^'),
        (252, 'u"'),
        (253, 'z\\v'),
        (254, 's]'),
        (255, 'z]'),
        ]
