#-*- coding:utf-8 -*-

#  Pybik -- A 3 dimensional magic cube game.
#  Copyright © 2009-2011  B. Clausius <barcc@gmx.de>
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.


# Ported from GNUbik
# Original filenames: select.c, select-common.c
# Original copyright and license from select.c:
#/*
#    A system to permit user selection of a block and rotation axis
#    of a magic cube.
#    Copyright (C) 1998,  2003  John Darrington
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 3 of the License,  or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#*/
# Original copyright and license from select-common.c:
#/*
#  A system to permit user selection of a block and rotation axis
#  of a magic cube.
#  Copyright (C) 2003  John Darrington
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License,  or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#*/


# This library provides  a means of picking a block using the mouse cursor.
# 
# Two mutually co-operative mechanisms are used in this library.  There is a
# timer callback,  which occurs at regular intervals.  There is also the mouse
# motion callback,  which occurs whenever the mouse cursor is moving.  If two
# consecutive timer callbacks occur,  without and intervening mouse motion callback,
# then the cursor is assumed to be stationary.
# 
# If a stationary mouse is detected,  the program goes on to determine which block
# in the cube (if any) the cursor is located upon.

from gtk import gdk
from gtk import gtkgl
from gtk import gdkgl

from .debug import debug
import glarea_common
import cube


class FacetSelection:
    pass


granularity = 1
if True:
    def pick_polygons(widget, lighting, x, y):
        '''Identify the block at screen co-ordinates x,y.
        
        This func determines all candidate blocks. That is, all blocks
        which orthogonally project to x,y. It then calls _choose_items,
        to determine which of them is closest to the screen.'''
        
        assert granularity > 0
        
        glcontext = gtkgl.widget_get_gl_context(widget)
        gldrawable = gtkgl.widget_get_gl_drawable(widget)
        
        if not gdkgl.Drawable.make_current(gldrawable, glcontext):
            debug("Cannot set gl drawable current")
            return
        
        height = widget.allocation.height
        #debug('widget_height', height)
        
        #TODO Fix pick mode 2 and remove pick mode 1
        # CubeArea.update_selection uses (axis, slice, dir)
        # and colour_sel.drag_data_received uses face, so pick_polygons should return 4 values
        closest = glarea_common.pick_polygons(lighting, x, height-y, granularity)
        #closest2 = glarea_common.pick_polygons(x, height-y, granularity, 2)
        #debug(closest, closest2)
        if closest is None:
            return None
            
        sel = FacetSelection()
        sel.block = closest[0]
        sel.face = closest[1]
        sel.quadrant = closest[2]
        sel.axis_o, sel.slice_o, sel.dir_o = cube.get_selected_move(sel.block, sel.face, sel.quadrant)
        #sel.axis = closest2 and closest2[0]
        #sel.slice = closest2 and closest2[1]
        #sel.dir = closest2 and closest2[2] == 2
        return sel
        


