#-*- coding:utf-8 -*-

#  Pybik -- A 3 dimensional magic cube game.
#  Copyright © 2009, 2011  B. Clausius <barcc@gmx.de>
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os

AUTHORS = ["B. Clausius"]
CONTACT = 'barcc@gmx.de'
COPYRIGHT = 'Copyright \xc2\xa9 2009-2011,  B. Clausius'
LICENSE_NAME = 'GNU GPL v3'
PACKAGE = 'pybik'
PACKAGE_NAME = 'Pybik'
VERSION = '0.4.2'
WEBSITE = 'https://launchpad.net/pybik/'

# The following two lines are replaced by setup.py
data_dir = os.path.join(os.path.dirname(os.path.dirname(__file__)), 'data')
appdata_dir = data_dir

IMAGE_FILE   = os.path.join(data_dir, 'pixmaps', PACKAGE+'.png')
UI_DIR       = os.path.join(appdata_dir, 'ui')
SCRIPT_DIR   = os.path.join(appdata_dir, 'scripts')
LOCALE_DIR   = os.path.join(data_dir, 'locale')

# Using functions, so that this module can be used before gettext was set up.
pass
get_appname = lambda: _('Pybik')
get_appname_short = lambda: _('Pybik')
get_description = lambda: _('Pybik is a 3 dimensional magic cube game.')
get_website_label = lambda: _('Pybik web site')

get_license = lambda: [
            _('This program is free software: you can redistribute it and/or modify '
            'it under the terms of the GNU General Public License as published by '
            'the Free Software Foundation, either version 3 of the License, or '
            '(at your option) any later version.'),

            _('This program is distributed in the hope that it will be useful, '
            'but WITHOUT ANY WARRANTY; without even the implied warranty of '
            'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the '
            'GNU General Public License for more details.'),

            _('You should have received a copy of the GNU General Public License '
            'along with this program.  If not, see <http://www.gnu.org/licenses/>.')
        ]


def get_data_home():
    return os.path.join(os.path.expanduser("~"), ".config", "pybik")
    
