#!/usr/bin/python

"""Listen on a TCP/IP port for incoming HTTP requests."""
# (C) Copyright IBM Corp. 2008-2009
# Licensed under the GPLv2.
import BaseHTTPServer
import thread
import discovery
from httplib import OK, NOT_FOUND
from urlparse import urlparse
from cgi import parse_qs
from urllib import unquote

HOST_NAME	= '0.0.0.0'
PORT_NUMBER	= 8036
XML_ROOT	= 'ReturnValues'
PWRKAP_CMD	= 'setpowercap'
PWRKAP_PARAM_OLD= 'pcap'
PWRKAP_PARAM	= 'pwrkap'
PWRDOM_PARAM	= 'pwrdom'

# The controller variable should be set before starting a new HTTP listener.
# The controller contains the method that actually sets a pwrkap.
pwrkap_controller = None

class http_server(BaseHTTPServer.HTTPServer):
	"""Extends the base HTTP server with the ability to invoke termination."""
	def serve_terminable(self):
		self.terminating = False
		while not self.terminating:
			self.handle_request()
	def server_close(self):
		BaseHTTPServer.HTTPServer.server_close(self)
		self.terminating = True

class http_handler(BaseHTTPServer.BaseHTTPRequestHandler):
	"""Defines methods to handle HTTP requests."""

	def do_HEAD(self):
		"""Respond to an HTTP HEAD request."""
		parsedURL = urlparse(self.path)
		if (unquote(parsedURL.path) != "/" + PWRKAP_CMD):
			self.send_error(NOT_FOUND, "The specified path or command does not exist.")
			return
		self.send_response(OK)
		self.send_header("Content-type", "text/html")
		self.end_headers()

	def do_GET(self):
		"""Respond to an HTTP GET request."""
		parsedURL = urlparse(self.path)
		if (unquote(parsedURL.path) != "/" + PWRKAP_CMD):
			self.send_error(NOT_FOUND, "The specified path or command does not exist.")
			return
		self.send_response(OK)
		self.send_header("Content-type", "text/xml")
		self.end_headers()

		print "Received request from", self.client_address
		params = parse_qs(parsedURL.query)
		pwrkap = -1
		powerDomainName = ""

		# Get the specified pwrkap value if it can be obtained from the parameters.
	# Use old parameter if specified, to avoid breaking older clients
		if (params.has_key(PWRKAP_PARAM_OLD) and len(params[PWRKAP_PARAM_OLD]) > 0):
			try:
				pwrkap = int(params[PWRKAP_PARAM_OLD][0])
			except ValueError:
				pwrkap = -1

		# Get the specified pwrkap value if it can be obtained from the parameters.
		if (params.has_key(PWRKAP_PARAM) and len(params[PWRKAP_PARAM]) > 0):
			try:
				pwrkap = int(params[PWRKAP_PARAM][0])
			except ValueError:
				pwrkap = -1

		if (pwrkap >= 0):
			# Get the specified power domain name if it can be obtained from
			# the parameters.  Otherwise, attempt to obtain the first power
			# domain name that can be found in the discovery module.
			if (params.has_key(PWRDOM_PARAM) and len(params[PWRDOM_PARAM]) > 0):
				powerDomainName = params[PWRDOM_PARAM][0]
			elif (len(discovery.PWRKAP_POWER_DOMAINS) > 0):
				print "Found at least one entry in PWRKAP_POWER_DOMAINS"
				powerDomainName = discovery.PWRKAP_POWER_DOMAINS[0].name()

			print "Power domain name:", powerDomainName

			if (discovery.find_domain_by_name(powerDomainName) != None):
				print "Attempting to set pwrkap to", pwrkap, "on power domain", \
					  powerDomainName, "..."
				if (pwrkap_controller != None):
					pwrkap_controller.command([powerDomainName, "cap", pwrkap])
				else:
					print "The pwrkap Controller was not defined.  An HTTP", \
						  "server should only be started via the", \
						  "http_listener class."
					pwrkap = -1
			else:
				print "The specified power domain name could not be", \
					  "identified.  Power cap will not be set."
				pwrkap = -1

		self.wfile.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>")
		self.wfile.write("<" + XML_ROOT + ">")

		self.wfile.write("<" + PWRKAP_CMD + ">")
		self.wfile.write("<" + PWRKAP_PARAM + ">" + str(pwrkap) + "</" + PWRKAP_PARAM + ">")
		self.wfile.write("<" + PWRDOM_PARAM + ">" + powerDomainName + "</" + PWRDOM_PARAM + ">")
		self.wfile.write("</" + PWRKAP_CMD + ">")

		self.wfile.write("</" + XML_ROOT + ">\n")

class http_listener:
	""" Defines the HTTP listener object that sets the global pwrkap controller
		to handle incoming capping requests and starts the HTTP server. """
	def __init__(self, controller):
		global pwrkap_controller
		pwrkap_controller = controller
		self.httpd = http_server((HOST_NAME, PORT_NUMBER), http_handler)
		thread.start_new_thread(self.httpd.serve_terminable, ())
	def stop(self):
		self.httpd.server_close()
