/***************************************************************************
                          submountwatcher.h  -  description
                             -------------------
    begin                : Tue May 10 2005
    copyright            : (C) 2005 by Markus Kalkbrenner
    email                : mkalkbrenner@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SUBMOUNTWATCHER_H
#define SUBMOUNTWATCHER_H

#include "prokyon.h"

#include <qthread.h>
#include <qmap.h>
#include <qfile.h>

class SubmountWatcher : public QThread  {
public:
    SubmountWatcher();

    void run();
    void stop();
    void pause();
    void proceed();
    void addDevice(QString device, QString dir);
    void keepMounted(QString device);
    void release(QString device);

private:
    QMutex mutex;
    bool stopCalled;
    bool paused;
    QMap<QString, QString> deviceStates;
    QMap<QString, QString> deviceMountpoints;
    QMap<QString, QFile*> devicesKeptMounted;

    QString scanDirectoryForFile(QString dir);
};

#endif
