/*-----------------------------------------------------------------------
QMBTagger - Qt Based MusicBrainz MP3/OGG/FLAC Tagger
Copyright (C) 2003,2004 Ewen Cheslack-Postava
 
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-----------------------------------------------------------------------*/

#include "qmbmetadata.h"

#if HAVE_LIBMUSICBRAINZ

QMBMetadata::QMBMetadata()
:trmid(""), artistName(""), albumName(""), trackName(""), trackNum(""), duration(""), fileName(""), artistId(""), albumId(""), trackId(""), relevance(0) {
}

QMBMetadata::~QMBMetadata() {
}

QMBMetadata& QMBMetadata::operator=(const QMBMetadata &m) {
                                       if (&m != this) {
                                           //don't copy the trmid, if we do then we would lose it some places
                                           artistName = m.artistName.latin1();
                                           albumName = m.albumName.latin1();
                                           trackName = m.trackName.latin1();
                                           trackNum = m.trackNum.latin1();
                                           duration = m.duration.latin1();
                                           fileName = m.fileName.latin1();
                                           artistId = m.artistId.latin1();
                                           albumId = m.albumId.latin1();
                                           trackId = m.trackId.latin1();
                                           relevance = m.relevance;
                                       }

                                       return *this;
                                   }

                                   QString QMBMetadata::GetTRMID() {
                                       return trmid;
                                   }

                                   QString QMBMetadata::GetArtistName() {
                                       return artistName;
                                   }

                                   QString QMBMetadata::GetCleanArtistName() {
                                       QString result = artistName;
                                       result.replace("/", "-");
                                       return result;
                                   }

                                   QString QMBMetadata::GetAlbumName() {
                                       return albumName;
                                   }

                                   QString QMBMetadata::GetCleanAlbumName() {
                                       QString result = albumName;
                                       result.replace("/", "-");
                                       return result;
                                   }

                                   QString QMBMetadata::GetTrackName() {
                                       return trackName;
                                   }

                                   QString QMBMetadata::GetCleanTrackName() {
                                       QString result = trackName;
                                       result.replace("/", "-");
                                       return result;
                                   }

                                   QString QMBMetadata::GetTrackNumber() {
                                       return trackNum;
                                   }

                                   QString QMBMetadata::GetPaddedTrackNumber() {
                                       QString ptn = trackNum;
                                       while (ptn.length() < 2) {
                                           ptn.prepend('0');
                                       }

                                       return ptn;
                                   }

                                   QString QMBMetadata::GetDuration() {
                                       return duration;
                                   }

                                   QString QMBMetadata::GetFormattedDuration() {
                                       QString formatted = "";

                                       int dur = duration.toInt() / 1000; //duration is stored in msec, but we don't need that much precision
                                       int hours = dur / 3600;
                                       dur = dur % 3600;
                                       int minutes = dur / 60;
                                       dur = dur % 60;
                                       int seconds = dur;

                                       QString sHours = QString::number(hours);
                                       if (sHours.length() < 2)
                                           sHours.prepend('0');
                                       QString sMinutes = QString::number(minutes);
                                       if (sMinutes.length() < 2)
                                           sMinutes.prepend('0');
                                       QString sSeconds = QString::number(seconds);
                                       if (sSeconds.length() < 2)
                                           sSeconds.prepend('0');

                                       formatted = sHours + ":" + sMinutes + "." + sSeconds;

                                       return formatted;
                                   }

                                   QString QMBMetadata::GetFileName() {
                                       return fileName;
                                   }

                                   QString QMBMetadata::GetArtistID() {
                                       return artistId;
                                   }

                                   QString QMBMetadata::GetAlbumID() {
                                       return albumId;
                                   }

                                   QString QMBMetadata::GetTrackID() {
                                       return trackId;
                                   }

                                   int QMBMetadata::GetRelevance() {
                                       return relevance;
                                   }

                                   void QMBMetadata::ReplaceFilenameWildcards(QString &filename, QString &ext) {
                                       filename.replace("{ARTIST}", GetCleanArtistName());
                                       filename.replace("{ALBUM}", GetCleanAlbumName());
                                       filename.replace("{TRACK}", GetCleanTrackName());
                                       filename.replace("{TRACKNUM}", GetTrackNumber());
                                       filename.replace("{PTN}", GetPaddedTrackNumber());
                                       filename.replace("{EXT}", ext);
                                   }

                                   void QMBMetadata::SetTRMID(QString trm) {
                                       trmid = trm.latin1();
                                   }

                                   void QMBMetadata::SetArtistName(QString artist) {
                                       artistName = artist.latin1();
                                   }

                                   void QMBMetadata::SetAlbumName(QString album) {
                                       albumName = album.latin1();
                                   }

                                   void QMBMetadata::SetTrackName(QString track) {
                                       trackName = track.latin1();
                                   }

                                   void QMBMetadata::SetTrackNumber(QString tnum) {
                                       trackNum = tnum.latin1();
                                   }

                                   void QMBMetadata::SetDuration(QString dur) {
                                       duration = dur.latin1();
                                   }

                                   void QMBMetadata::SetFileName(QString file) {
                                       fileName = file.latin1();
                                   }

                                   void QMBMetadata::SetArtistID(QString id) {
                                       artistId = id.latin1();
                                   }

                                   void QMBMetadata::SetAlbumID(QString id) {
                                       albumId = id.latin1();
                                   }

                                   void QMBMetadata::SetTrackID(QString id) {
                                       trackId = id.latin1();
                                   }

                                   void QMBMetadata::SetRelevance(int rel) {
                                       relevance = rel;
                                   }

                                   void QMBMetadata::debugDump() {
                                       qWarning(("trmid: " + trmid).local8Bit().data());
                                       qWarning(("artistName: " + artistName).local8Bit().data());
                                       qWarning(("albumName: " + albumName).local8Bit().data());
                                       qWarning(("trackName: " + trackName).local8Bit().data());
                                       qWarning(("trackNum: " + trackNum).local8Bit().data());
                                       qWarning(("duration: " + duration).local8Bit().data());
                                       qWarning(("fileName: " + fileName).local8Bit().data());
                                       qWarning(("artistId: " + artistId).local8Bit().data());
                                       qWarning(("albumId: " + albumId).local8Bit().data());
                                       qWarning(("trackId: " + trackId).local8Bit().data());
                                       qWarning(("relevance: " + QString::number(relevance)).local8Bit().data());
                                   }

                                   #endif /*HAVE_LIBMUSICBRAINZ*/
