/***************************************************************************
                    musicbrainzquery_dialog.h  -  description
                             -------------------
    begin                : Mon Sep 27 2004
    copyright            : (C) 2004 by Markus Kalkbrenner
    email                : mkalkbrenner@users.sourceforge.net
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MUSICBRAINZQUERY_DIALOG_H
#define MUSICBRAINZQUERY_DIALOG_H

#if HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#if HAVE_LIBMUSICBRAINZ

#include "gui_taglisting.h"
#include "extendedlistview.h"
#include "lvi_musicbrainzresult.h"

#include <qpushbutton.h>

#endif /*HAVE_LIBMUSICBRAINZ*/

#include <qdialog.h>
#include <qstring.h>

class MusicBrainzQuery_Dialog : public QDialog {
    Q_OBJECT

    #if HAVE_LIBMUSICBRAINZ

    friend class GUI_TagListing;

    #endif /*HAVE_LIBMUSICBRAINZ*/

public:
    MusicBrainzQuery_Dialog(QWidget *parent, const QString &path, const char *name=0);
    ~MusicBrainzQuery_Dialog();

    #if HAVE_LIBMUSICBRAINZ

    LVI_MusicBrainzResult* getSelected();

    #endif /*HAVE_LIBMUSICBRAINZ*/

    enum DialogCode { SkipRemaining = 0x100 };

private:
    #if HAVE_LIBMUSICBRAINZ

    QString fullPath;
    ExtendedListView *result_view;
    QPushButton *button_select, *button_cancel, *button_skip_remaining;

    LVI_MusicBrainzResult *selected;
    #endif /*HAVE_LIBMUSICBRAINZ*/

private slots:
    void slot_queryServer();
    void slot_selectionChanged();
    void slot_select();
    void slot_cancel();
    void slot_skipRemaining();
};

#endif
