#include "gui_selector.h"

#include "datadispatcher.h"
#include "gui.h"
#include "configuration.h"
#include "jobmanager.h"
#include "job_modifyfavourite.h"
#include "job_querydatabase.h"
#include "job_deletemediumfromdatabase.h"
#include "job_countdata.h"
#include "job_playalbum.h"
#include "job_renamemedium.h"
#include "pixmapcache.h"
#include "lvi_medium.h"

#include <qpushbutton.h>
#include <qpopupmenu.h>
#include <qheader.h>
#include <qobject.h>
#include <qobjectlist.h>
#include <qtooltip.h>
#include <qptrlist.h>

// ##############################################
// # initialize selection gui
// ##############################################
GUI_Selector::GUI_Selector(QWidget *parent, const char *name)
: QTabWidget(parent, name) {

    tabArtists = new QFrame();
    QToolTip::add
        ( tabArtists, _( "Click on a letter to scroll to\na specific artist name." ) );
    QVBoxLayout *blay = new QVBoxLayout(tabArtists);

    // *** tab artist ***
    artistButtonFrame = new QFrame(tabArtists);
    artistButtonFrameLayout = new QGridLayout(artistButtonFrame, 7, 6);

    artistStack = new QWidgetStack(tabArtists);

    blay->addWidget(artistButtonFrame);
    blay->addWidget(artistStack, 2);

    // add buttons
    //  addButton("Favs", 0, 0, 0, 0, 1);
    addButton("0-9", 1, 0, 0, 2, 3);
    addButton("A",   2, 0, 0, 4, 4);
    addButton("B",   3, 0, 0, 5, 5);
    addButton("C",   4, 1, 1, 0, 0);
    addButton("D",   5, 1, 1, 1, 1);
    addButton("E",   6, 1, 1, 2, 2);
    addButton("F",   7, 1, 1, 3, 3);
    addButton("G",   8, 1, 1, 4, 4);
    addButton("H",   9, 1, 1, 5, 5);
    addButton("I",  10, 2, 2, 0, 0);
    addButton("J",  11, 2, 2, 1, 1);
    addButton("K",  12, 2, 2, 2, 2);
    addButton("L",  13, 2, 2, 3, 3);
    addButton("M",  14, 2, 2, 4, 4);
    addButton("N",  15, 2, 2, 5, 5);
    addButton("O", 16, 3, 3, 0, 0);
    addButton("P", 17, 3, 3, 1, 1);
    addButton("Q", 18, 3, 3, 2, 2);
    addButton("R", 19, 3, 3, 3, 3);
    addButton("S", 20, 3, 3, 4, 4);
    addButton("T", 21, 3, 3, 5, 5);
    addButton("U", 22, 4, 4, 0, 0);
    addButton("V", 23, 4, 4, 1, 1);
    addButton("W", 24, 4, 4, 2, 2);
    addButton("X", 25, 4, 4, 3, 3);
    addButton("Y", 26, 4, 4, 4, 4);
    addButton("Z", 27, 4, 4, 5, 5);
    addButton("AllTree",28, 5, 6, 0, 5);
    addButton("+", 29, 0, 0, 0, 0);
    addButton("-", 31, 0, 0, 1, 1);

    slot_buttonSelected_0();

    // *** tab media ***
    tabCDROM = new QListView();
    QString temps1 = _( "Select a disc,CD,shared drive...\nto view all tracks on this media." );
    QToolTip::add
        ( tabCDROM, temps1 );
    QToolTip::add
        ( tabCDROM->viewport(), temps1 );
    tabCDROM->addColumn(_("All Media"), -1);
    tabCDROM->setHScrollBarMode(QScrollView::AlwaysOff);
    tabCDROM->setSorting(-1);

    connect(tabCDROM, SIGNAL(contextMenuRequested(QListViewItem*, const QPoint&, int)),
            this, SLOT(slot_contextMenu(QListViewItem*, const QPoint&, int)));
    connect(tabCDROM, SIGNAL(selectionChanged(QListViewItem*)), this, SLOT(slot_lviSelected(QListViewItem*)));
    connect(tabCDROM, SIGNAL(clicked(QListViewItem*)), this, SLOT(slot_lviSelected(QListViewItem*)));

    // *** tab favorites ***
    tabFavourites = new QListView();
    QString temps2 = _("Select a favourite artist to display albums");
    QToolTip::add
        ( tabFavourites, temps2);
    QToolTip::add
        ( tabFavourites->viewport(), temps2);
    tabFavourites->addColumn(_("Favourite Artists"), -1);
    tabFavourites->setHScrollBarMode(QScrollView::AlwaysOn);
    tabFavourites->setRootIsDecorated( true );
    tabFavourites->setItemMargin(1);
    tabFavourites->setShowSortIndicator(true);

    connect(tabFavourites, SIGNAL(selectionChanged(QListViewItem*)), this, SLOT(slot_lviSelected(QListViewItem*)));
    connect(tabFavourites, SIGNAL(clicked(QListViewItem*)), this, SLOT(slot_lviSelected(QListViewItem*)));
    connect(tabFavourites, SIGNAL(contextMenuRequested(QListViewItem*, const QPoint&, int)), this, SLOT(slot_contextMenu(QListViewItem*, const QPoint&, int)));
    connect(tabFavourites, SIGNAL(doubleClicked(QListViewItem*)), this, SLOT(slot_doubleclicked(QListViewItem*)));

    // *** tab album ***
    tabAlbum = new QListView();
    QString temps3 = _( "Select an album from your sampler/soundtrack view.\nTracks are tagged as a comment" );
    QToolTip::add
        ( tabAlbum, temps3 );
    QToolTip::add
        ( tabAlbum->viewport(), temps3 );
    tabAlbum->addColumn(_("Sampler"), -1);
    tabAlbum->setHScrollBarMode(QScrollView::AlwaysOn);
    tabAlbum->setRootIsDecorated( true );
    tabAlbum->setItemMargin(1);
    tabAlbum->setShowSortIndicator(true);

    connect(tabAlbum, SIGNAL(selectionChanged(QListViewItem*)), this, SLOT(slot_lviSelected(QListViewItem*)));
    connect(tabAlbum, SIGNAL(clicked(QListViewItem*)), this, SLOT(slot_lviSelected(QListViewItem*)));
    connect(tabAlbum, SIGNAL(contextMenuRequested(QListViewItem*, const QPoint&, int)), this, SLOT(slot_contextMenu(QListViewItem*, const QPoint&, int)));
    connect(tabAlbum, SIGNAL(doubleClicked(QListViewItem*)), this, SLOT(slot_doubleclicked(QListViewItem*)));

    // TRANSLATORS: short form of 'Artist'
    addTab(tabArtists, _("Art."));
    // TRANSLATORS: short form of 'Favourite'
    addTab(tabFavourites, _("Fav."));
    addTab(tabCDROM, _("Media"));
    // TRANSLATORS: short form of 'Album'
    addTab(tabAlbum, _("Alb."));

    connect(this, SIGNAL(currentChanged(QWidget*)), this, SLOT(slot_tabSelected(QWidget*)));

    rwLock = 0;
    localDelta = 0;
    lastLVI = NULL;
    #ifdef HAVE_MIXXX

    isMixxxConnected = false;
    #endif /* HAVE_MIXXX */
}

// ##############################################
// # add one button to gui
// ##############################################
void GUI_Selector::addButton(QString letter, int id, int x1, int x2, int y1, int y2) {
    // create button
    QPushButton *button;
    if(letter != "AllTree" && letter != "Favs") {
        button = new QPushButton(letter, artistButtonFrame);
        button->setMinimumWidth(16);
        button->setMaximumHeight(fontMetrics().height());
        button->setMinimumHeight(14);
        artistButtonFrameLayout->addMultiCellWidget(button, x1, x2, y1, y2);
    }

    // create list
    if(letter == "AllTree" || letter == "Favs") {
        mapArtistList[letter] = new QListView(artistStack);
        QString temps = _("Select an artist or an album\nto view tracks.\n");
        QToolTip::add
            ( mapArtistList[letter], temps);
        QToolTip::add
            ( mapArtistList[letter]->viewport(), temps);
        mapArtistList[letter]->addColumn(QString(_("Artists")) + " "/* + letter*/, -1);
        mapArtistList[letter]->setHScrollBarMode(QScrollView::AlwaysOn);
        mapArtistList[letter]->setRootIsDecorated( true );
        mapArtistList[letter]->setItemMargin(1);
        mapArtistList[letter]->setShowSortIndicator(true);
        artistStack->addWidget(mapArtistList[letter], id);
    }


    // set connections
    if(letter == "0-9")
        connect(button, SIGNAL(clicked()), this, SLOT(slot_buttonSelected_0()));
    else if(letter == "A")
        connect(button, SIGNAL(clicked()), this, SLOT(slot_buttonSelected_A()));
    else if(letter == "B")
        connect(button, SIGNAL(clicked()), this, SLOT(slot_buttonSelected_B()));
    else if(letter == "C")
        connect(button, SIGNAL(clicked()), this, SLOT(slot_buttonSelected_C()));
    else if(letter == "D")
        connect(button, SIGNAL(clicked()), this, SLOT(slot_buttonSelected_D()));
    else if(letter == "E")
        connect(button, SIGNAL(clicked()), this, SLOT(slot_buttonSelected_E()));
    else if(letter == "F")
        connect(button, SIGNAL(clicked()), this, SLOT(slot_buttonSelected_F()));
    else if(letter == "G")
        connect(button, SIGNAL(clicked()), this, SLOT(slot_buttonSelected_G()));
    else if(letter == "H")
        connect(button, SIGNAL(clicked()), this, SLOT(slot_buttonSelected_H()));
    else if(letter == "I")
        connect(button, SIGNAL(clicked()), this, SLOT(slot_buttonSelected_I()));
    else if(letter == "J")
        connect(button, SIGNAL(clicked()), this, SLOT(slot_buttonSelected_J()));
    else if(letter == "K")
        connect(button, SIGNAL(clicked()), this, SLOT(slot_buttonSelected_K()));
    else if(letter == "L")
        connect(button, SIGNAL(clicked()), this, SLOT(slot_buttonSelected_L()));
    else if(letter == "M")
        connect(button, SIGNAL(clicked()), this, SLOT(slot_buttonSelected_M()));
    else if(letter == "N")
        connect(button, SIGNAL(clicked()), this, SLOT(slot_buttonSelected_N()));
    else if(letter == "O")
        connect(button, SIGNAL(clicked()), this, SLOT(slot_buttonSelected_O()));
    else if(letter == "P")
        connect(button, SIGNAL(clicked()), this, SLOT(slot_buttonSelected_P()));
    else if(letter == "Q")
        connect(button, SIGNAL(clicked()), this, SLOT(slot_buttonSelected_Q()));
    else if(letter == "R")
        connect(button, SIGNAL(clicked()), this, SLOT(slot_buttonSelected_R()));
    else if(letter == "S")
        connect(button, SIGNAL(clicked()), this, SLOT(slot_buttonSelected_S()));
    else if(letter == "T")
        connect(button, SIGNAL(clicked()), this, SLOT(slot_buttonSelected_T()));
    else if(letter == "U")
        connect(button, SIGNAL(clicked()), this, SLOT(slot_buttonSelected_U()));
    else if(letter == "V")
        connect(button, SIGNAL(clicked()), this, SLOT(slot_buttonSelected_V()));
    else if(letter == "W")
        connect(button, SIGNAL(clicked()), this, SLOT(slot_buttonSelected_W()));
    else if(letter == "X")
        connect(button, SIGNAL(clicked()), this, SLOT(slot_buttonSelected_X()));
    else if(letter == "Y")
        connect(button, SIGNAL(clicked()), this, SLOT(slot_buttonSelected_Y()));
    else if(letter == "Z")
        connect(button, SIGNAL(clicked()), this, SLOT(slot_buttonSelected_Z()));
    else if(letter == "+")
        connect(button, SIGNAL(clicked()), this, SLOT(notifyOpenSelectorTree()));
    else if(letter == "-")
        connect(button, SIGNAL(clicked()), this, SLOT(notifyCloseSelectorTree()));
    if(letter == "AllTree") {
        connect(mapArtistList[letter], SIGNAL(selectionChanged(QListViewItem*)), this, SLOT(slot_lviSelected(QListViewItem*)));
        connect(mapArtistList[letter], SIGNAL(clicked(QListViewItem*)), this, SLOT(slot_lviSelected(QListViewItem*)));
        connect(mapArtistList[letter], SIGNAL(contextMenuRequested(QListViewItem*, const QPoint&, int)), this, SLOT(slot_contextMenu(QListViewItem*, const QPoint&, int)));
        connect(mapArtistList[letter], SIGNAL(doubleClicked(QListViewItem*)), this, SLOT(slot_doubleclicked(QListViewItem*)));
    }
}

#ifdef HAVE_MIXXX
void GUI_Selector::setMixxxConnectionState(bool state) {
    isMixxxConnected = state;
}
#endif /* HAVE_MIXXX */

// ##############################################
// # callbacks for the buttons
// ##############################################
void GUI_Selector::slot_buttonSelected_AllTree() {
    artistStack->raiseWidget(mapArtistList["AllTree"]);
}

void GUI_Selector::slot_buttonSelected_0()   {
    QListView *list = mapArtistList["AllTree"];
    artistStack->raiseWidget(list);
    list->ensureItemVisible(list->firstChild());
}

void GUI_Selector::showLetter(QString letter) {
    QListView *list = mapArtistList["AllTree"];
    artistStack->raiseWidget(list);
    QListViewItem *lvi = list->firstChild();
    if(lvi == 0) {
        list->ensureItemVisible(lvi);
        return;
    }
    while(lvi != 0 && lvi->text(0).upper().localeAwareCompare(letter) < 0)
        lvi = lvi->nextSibling();
    list->ensureItemVisible(list->lastItem()->parent());
    if(lvi != 0)
        list->ensureItemVisible(lvi);
}

void GUI_Selector::slot_buttonSelected_A() {
    showLetter("A");
}
void GUI_Selector::slot_buttonSelected_B() {
    showLetter("B");
}
void GUI_Selector::slot_buttonSelected_C() {
    showLetter("C");
}
void GUI_Selector::slot_buttonSelected_D() {
    showLetter("D");
}
void GUI_Selector::slot_buttonSelected_E() {
    showLetter("E");
}
void GUI_Selector::slot_buttonSelected_F() {
    showLetter("F");
}
void GUI_Selector::slot_buttonSelected_G() {
    showLetter("G");
}
void GUI_Selector::slot_buttonSelected_H() {
    showLetter("H");
}
void GUI_Selector::slot_buttonSelected_I() {
    showLetter("I");
}
void GUI_Selector::slot_buttonSelected_J() {
    showLetter("J");
}
void GUI_Selector::slot_buttonSelected_K() {
    showLetter("K");
}
void GUI_Selector::slot_buttonSelected_L() {
    showLetter("L");
}
void GUI_Selector::slot_buttonSelected_M() {
    showLetter("M");
}
void GUI_Selector::slot_buttonSelected_N() {
    showLetter("N");
}
void GUI_Selector::slot_buttonSelected_O() {
    showLetter("O");
}
void GUI_Selector::slot_buttonSelected_P() {
    showLetter("P");
}
void GUI_Selector::slot_buttonSelected_Q() {
    showLetter("Q");
}
void GUI_Selector::slot_buttonSelected_R() {
    showLetter("R");
}
void GUI_Selector::slot_buttonSelected_S() {
    showLetter("S");
}
void GUI_Selector::slot_buttonSelected_T() {
    showLetter("T");
}
void GUI_Selector::slot_buttonSelected_U() {
    showLetter("U");
}
void GUI_Selector::slot_buttonSelected_V() {
    showLetter("V");
}
void GUI_Selector::slot_buttonSelected_W() {
    showLetter("W");
}
void GUI_Selector::slot_buttonSelected_X() {
    showLetter("X");
}
void GUI_Selector::slot_buttonSelected_Y() {
    showLetter("Y");
}
void GUI_Selector::slot_buttonSelected_Z() {
    showLetter("Z");
}

void GUI_Selector::slot_buttonSelected_Favourites() {
    artistStack->raiseWidget(mapArtistList["Favs"]);
}

// ##############################################
// # callback for tab selection
// ##############################################
void GUI_Selector::slot_tabSelected(QWidget *widget) {
    QListViewItem *lvi;

    if(widget == tabArtists) {
        artistStack->visibleWidget()->setFocus();
        lvi = mapArtistList["AllTree"]->currentItem();
        gui->getTagListing()->notifyEnableEdit(true);
    } else if(widget == tabCDROM) {
        tabCDROM->setFocus();
        lvi = tabCDROM->currentItem();
        gui->getTagListing()->notifyEnableEdit(true);
    } else if(widget == tabAlbum) {
        tabAlbum->setFocus();
        lvi = tabAlbum->currentItem();
        gui->getTagListing()->notifyEnableEdit(true);
    } else if(widget == tabFavourites) {
        tabFavourites->setFocus();
        lvi = tabFavourites->currentItem();
        gui->getTagListing()->notifyEnableEdit(false);
    }

    if(lvi != 0) {
        lastLVI = 0;  // force list refresh;
        slot_lviSelected(lvi);
    } else {
        gui->getListing()->clear();
        #ifdef HAVE_MEXTRAS

        EXTRADATA_GUI*  extra = new EXTRADATA_GUI;
        datadispatcher->eventNewExtraData( extra ); //force extras data clear
        delete extra;
        #endif /* HAVE_MEXTRAS */

    };
}

// ##############################################
// # callback for contextmenu
// ##############################################
void GUI_Selector::slot_contextMenu(QListViewItem* item, const QPoint &point, int) {
    QPopupMenu *menu = new QPopupMenu(this);

    if(item->listView() == tabCDROM) {
        LVI_Medium *lvi = static_cast<LVI_Medium*>(item);
        switch(lvi->getType()) {
        case MEDIUM_HARDDISK:
            return;
        case MEDIUM_CDROM:
            if(lvi->getIsLocked())
                return;

            menu->insertItem(pixmapcache->get
                             ("action_rename.png"), _("Rename Medium"), this, SLOT(slot_menuRenameMedium()), 0, 0);
            if(rwLock > 0)
                menu->setItemEnabled(0, false);
            menu->insertItem(pixmapcache->get
                             ("action_remove.png"), _("Remove from Database"), this, SLOT(slot_menuDeleteMediumFromDatabase()), 0, 1);
            if(rwLock > 0)
                menu->setItemEnabled(1, false);
            break;
        case MEDIUM_SMB:
            if(lvi->getIsLocked())
                return;

            menu->insertItem(pixmapcache->get
                             ("action_remove.png"), _("Remove from Database"), this, SLOT(slot_menuDeleteMediumFromDatabase()), 0, 1);
            if(rwLock > 0)
                menu->setItemEnabled(1, false);
            break;
        case MEDIUM_NFS:
            if(lvi->getIsLocked())
                return;

            menu->insertItem(pixmapcache->get
                             ("action_remove.png"), _("Remove from Database"), this, SLOT(slot_menuDeleteMediumFromDatabase()), 0, 1);
            if(rwLock > 0)
                menu->setItemEnabled(1, false);
            break;
        }
        menu->exec(point, 0);
    } else if(item->listView() == mapArtistList["AllTree"]
              || item->listView() == tabFavourites
              || item->listView() == tabAlbum) {
        LVI_Album *lvi = static_cast<LVI_Album*>(item);
        if(lvi->getIsArtist()) {
            // Album categories on album tab are treated as artists because the old
            // code regarding artists was reused. So here we have to avoid that a
            // category could be marked as favourite artist.
            if(item->listView() != tabAlbum) {
                if(lvi->getIsArtistFavourite()) {
                    // this one is tricky:
                    // the id of the current artist is used as id of the menu item
                    // so it's possible to pass the current artist directly to the slot
                    menu->insertItem(pixmapcache->get
                                     ("lvi_artist.png"), _("Remove Artist from Favourites"), this, SLOT(slot_menuDeleteFavourite(int)), 0, lvi->getArtistId(), 1);
                } else {
                    menu->insertItem(pixmapcache->get
                                     ("lvi_artist_favourite.png"), _("Add Artist to Favourites"), this, SLOT(slot_menuAddFavourite(int)), 0, lvi->getArtistId(), 1);
                }
                menu->exec(point, 0);
            }
        } else {  // Not an artist. Must be an album.
            int i = 0;
            #ifdef HAVE_MIXXX

            if (lvi->getLocal() && config->RegularPlayerEnabled()) { //display album popup menu if tracks available
                #endif /* HAVE_MIXXX */
                int play_regular = menu->insertItem(pixmapcache->get
                                                    ("player_play.png"), _("Play album with regular player"), this, SLOT(slot_menuPlayXmms(int)), 0, ++i);
                int enqueue_regular = menu->insertItem(pixmapcache->get
                                                       ("player_enqueue.png"), _("Enqueue album at regular player"), this, SLOT(slot_menuEnqueueXmms(int)), 0, ++i);
                #ifdef HAVE_MIXXX

                if (lvi->getLocal() && config->MixxxPlayerEnabled() && isMixxxConnected)
                    menu->insertSeparator(++i);
            }
            if (lvi->getLocal() && config->MixxxPlayerEnabled() && isMixxxConnected) { //display album popup menu if tracks available
                int enqueue_ch1 = menu->insertItem(pixmapcache->get
                                                   ("prelisten_enqueue.png"), _("mixxx: enqueue at channel 1"), this, SLOT(slot_mixxxEnqueueAtChannel1(int)), 0, ++i);
                int enqueue_ch2 = menu->insertItem(pixmapcache->get
                                                   ("prelisten_enqueue.png"), _("mixxx: enqueue at channel 2"), this, SLOT(slot_mixxxEnqueueAtChannel2(int)), 0, ++i);
            }
            #endif /* HAVE_MIXXX */
            menu->exec(point, 0);
        }
    }
}

// ##############################################
// # callbacks for menuitems
// ##############################################
void GUI_Selector::slot_menuPlayXmms(int menuPos) {
    createJobPlayAlbum(XMMS_PLAY);
}

void GUI_Selector::slot_menuEnqueueXmms(int menuPos) {
    createJobPlayAlbum(XMMS_ENQUEUE);
}

void GUI_Selector::slot_mixxxEnqueueAtChannel1(int menuPos) {
    #ifdef HAVE_MIXXX
    createJobPlayAlbum(CH1_ENQUEUE);
    #endif /* HAVE_MIXXX */
}

void GUI_Selector::slot_mixxxEnqueueAtChannel2(int menuPos) {
    #ifdef HAVE_MIXXX
    createJobPlayAlbum(CH2_ENQUEUE);
    #endif /* HAVE_MIXXX */
}

void GUI_Selector::createJobPlayAlbum(int type) {
    QListViewItem* lvi;
    if(currentPage() == tabArtists) {
        lvi = mapArtistList["AllTree"]->currentItem();
    } else {
        lvi = dynamic_cast<QListView*>(currentPage())->currentItem();
    }
    jobman->addJob(new Job_PlayAlbum( type, lvi->parent()->text(0), lvi->text(0) ) );
}

void GUI_Selector::slot_menuAddFavourite(int id) {
    jobman->addJob(new Job_ModifyFavourite(id, true));
    mapArtistList["AllTree"]->currentItem()->setPixmap(0, pixmapcache->get
            ("lvi_artist_favourite.png"));
    static_cast<LVI_Album*>(mapArtistList["AllTree"]->currentItem())->setIsArtistFavourite(true);
}

void GUI_Selector::slot_menuDeleteFavourite(int id) {
    QListViewItem *lvi;
    if(currentPage() == tabArtists) {
        lvi = mapArtistList["AllTree"]->currentItem();
    } else if(currentPage() == tabFavourites) {
        lvi = mapArtistList["AllTree"]->findItem(tabFavourites->currentItem()->text(0), 0, Qt::ExactMatch);
    }

    if(lvi) {
        lvi->setPixmap(0, pixmapcache->get
                       ("lvi_artist.png"));
        static_cast<LVI_Album*>(lvi)->setIsArtistFavourite(false);
    }
    jobman->addJob(new Job_ModifyFavourite(id, false));
}

void GUI_Selector::slot_menuDeleteMediumFromDatabase() {
    LVI_Medium *lvi = static_cast<LVI_Medium*>(tabCDROM->currentItem());
    jobman->addJob(new Job_DeleteMediumFromDatabase(lvi));
}

void GUI_Selector::slot_menuRenameMedium() {
    LVI_Medium *lvi = static_cast<LVI_Medium*>(tabCDROM->currentItem());
    MEDIUM *medium = new MEDIUM();
    medium->id       = lvi->getID();
    medium->label    = lvi->getLabel();
    medium->checksum = lvi->getChecksum();
    medium->path     = lvi->getPath();
    medium->type     = lvi->getType();
    jobman->addJob(new Job_RenameMedium(medium));
}

// ##############################################
// # callback for lvi selection
// ##############################################
void GUI_Selector::slot_lviSelected(QListViewItem* lvi) {
    //  qWarning("slot_lviSelected begin lvi:%p rwLock:%d", lvi, rwLock);

    // We connected clicked and selected signals to this slot.
    // So this slot is often called twice without a new lvi was selected.
    // If this happens we return immediately. MK
    if(!lvi || rwLock > 0 || lvi == lastLVI)
        return;
    lastLVI = lvi;

    if(lvi->listView() == tabCDROM) {
        LVI_Medium *item = static_cast<LVI_Medium*>(lvi);
        if(item->getType() == MEDIUM_HARDDISK && config->getAvoidHDD() == 1)
            return;
        if(item->getType() == MEDIUM_SMB && config->getAvoidSMB() == 1)
            return;
        if(item->getType() == MEDIUM_NFS && config->getAvoidNFS() == 1)
            return;
        jobman->addJob(new Job_QueryDatabase(QUERY_BY_MEDIUM, item->getID()));
    } else  if (lvi->listView() == mapArtistList["AllTree"] || lvi->listView() == tabFavourites ) {
        if ( verbose == 5)
            qWarning( "name:\"%s\" total:%i local:%i", static_cast<LVI_Album*>(lvi)->text(0).local8Bit().data(),static_cast<LVI_Album*>(lvi)->getTotal(), static_cast<LVI_Album*>(lvi)->getLocal() );
        if ( lvi->parent()
           ) {
            jobman->addJob(new Job_QueryDatabase(QUERY_BY_ARTIST_ALBUM, lvi->parent()->text(0), lvi->text(0) ) );
        } else {
            jobman->addJob(new Job_QueryDatabase(QUERY_BY_ARTIST_ALBUM, lvi->text(0), NULL) );
        }

    } else  if (lvi->listView() == tabAlbum) {
        if ( lvi->parent() ) {
            jobman->addJob(new Job_QueryDatabase(QUERY_BY_ALBUM, revertAlbumTypeTranslation(lvi->parent()->text(0)), lvi->text(0) ) );
            if (verbose == 5)
                qWarning("Running sampler lvi :%s:%s",  lvi->parent()->text(0).local8Bit().data(), lvi->text(0).local8Bit().data());
        } else {
            jobman->addJob(new Job_QueryDatabase(QUERY_BY_ALBUM, revertAlbumTypeTranslation(lvi->text(0)), NULL) );
            if ( verbose == 5 )
                qWarning("Running sampler lvi :%s", lvi->text(0).local8Bit().data());
        }
    }

    return;
}

void GUI_Selector::slot_doubleclicked(QListViewItem* lvi) {
    if ( lvi->parent() )
        slot_menuPlayXmms( lvi->itemPos() );
    return;
}

// ##############################################
// # adjust the widget size
// ##############################################
void GUI_Selector::correctSize() {
    QMap<QString, QListView*>::Iterator it = mapArtistList.begin();
    for(; it != mapArtistList.end(); ++it) {
        it.data()->setColumnWidth(0, dynamic_cast<QListView*>(artistStack->visibleWidget())->visibleWidth());
    }
    tabCDROM->setColumnWidth(0, dynamic_cast<QListView*>(artistStack->visibleWidget())->visibleWidth());
}

void GUI_Selector::slot_setConnectionState(bool state) {
    isConnected = state;
    if(!isConnected)
        clear();
}

// ##############################################
// *** New notify functions ***
// ##############################################

void GUI_Selector::notifyCloseSelectorTree() {
    // hide all albums.
    QListView *list = mapArtistList["AllTree"];
    QListViewItem * myChild = list->firstChild();
    while( myChild ) {
        myChild->setOpen(false);
        myChild = myChild->nextSibling();
    }
}

void GUI_Selector::notifyOpenSelectorTree() {
    // show all albums.
    QListView *list = mapArtistList["AllTree"];
    QListViewItem * myChild = list->firstChild();
    while( myChild ) {
        myChild->setOpen(true);
        myChild = myChild->nextSibling();
    }
}


void GUI_Selector::notifyMediumAvailabilityChanged(int id, bool isAvailable) {
    if(mapMediumByID.contains(id)) {
        mapIsAvailable[id] = isAvailable;
        mapMediumByID[id]->setAvailability(isAvailable);
        applyLocalAlbumDelta(id, isAvailable);
    }

    adjustIconsOnTab(tabFavourites);
    adjustIconsOnTab(tabAlbum);
}

void GUI_Selector::adjustIconsOnTab(QListView *tab) {
    QListViewItemIterator it( tab );
    while ( it.current() ) {
        LVI_Album *lvi = static_cast<LVI_Album*>(it.current());
        if ( mapIsAvailable.contains(lvi->getMedium()) )
            lvi->adjustIcon(mapIsAvailable[lvi->getMedium()]);
        ++it;
    }
}

void GUI_Selector::notifyNewSamplerBasis(QList<ARTISTALBUM> *tracklist) {
    setNewBasisOnTab(tracklist, tabAlbum, true);
    adjustIconsOnTab(tabAlbum);
}

void GUI_Selector::notifyNewFavouritesBasis(QList<ARTISTALBUM> *tracklist) {
    setNewBasisOnTab(tracklist, tabFavourites, false);
    adjustIconsOnTab(tabFavourites);
}

void GUI_Selector::notifyMediumRenamed(MEDIUM *medium) {
    LVI_Medium *lvi = mapMediumByID[medium->id];
    lvi->setText(0, medium->label);
    lvi->setLabel(medium->label);
    if (tabCDROM->isShown() &&
            tabCDROM->selectedItem() == lvi) {
        // force update
        lastLVI = 0;
        slot_lviSelected(lvi);
    }
}

void GUI_Selector::setNewBasisOnTab(QList<ARTISTALBUM> *tracklist, QListView *tab, bool open) {
    if(!isConnected)
        return;

    QListViewItem *prevItem = tab->currentItem();
    QString prevItemName( NULL );
    if(prevItem != 0)
        prevItemName = prevItem->text(0);

    tab->clear();

    QString lastartist( NULL );
    LVI_Album *lv, *llv;
    for(ARTISTALBUM *curr = tracklist->first(); curr != 0; curr = tracklist->next()) {
        if(tab == tabAlbum) {
            curr->artist = _(curr->artist.local8Bit().data());
        }
        if ( curr->artist == lastartist ) {
            llv = new LVI_Album( lv, curr);
            lv->addLocal(llv->getLocal());
            lv->addTotal(llv->getTotal());
        } else {
            lv = new LVI_Album( tab, curr );
            lv->setOpen( open );
            llv = new LVI_Album( lv, curr );
            lv->addLocal(llv->getLocal());
            lv->addTotal(llv->getTotal());
        }
        lastartist = curr->artist;
    }

    if(tab->childCount() != 0) {
        if(tab != currentPage()) {
            disconnect(tab, SIGNAL(selectionChanged(QListViewItem*)), this, SLOT(slot_lviSelected(QListViewItem*)));
        }

        QListViewItem *newItem;
        newItem=NULL;
        if(prevItem != 0)
            newItem = tab->findItem(prevItemName, 0, Qt::ExactMatch);
        if(newItem != 0) {
            tab->setSelected(newItem, true);
        } else {
            tab->setSelected(tab->firstChild(), true);
        }

        if(tab != currentPage()) {
            connect(tab, SIGNAL(selectionChanged(QListViewItem*)), this, SLOT(slot_lviSelected(QListViewItem*)));
        }
    } else if(currentPage() == tab) {
        gui->getListing()->clear();
    }
}

void GUI_Selector::notifyNewArtistAlbumBasis(QList<ARTISTALBUM> *tracklist, bool select) {
    if(!isConnected)
        return;

    QString lastartist( NULL );
    LVI_Album *lv, *llv;
    for(ARTISTALBUM *curr = tracklist->first(); curr != 0; curr = tracklist->next()) {
        if ( curr->artist == lastartist ) {
            llv = new LVI_Album( lv, curr);
            lv->addLocal(llv->getLocal());
            lv->addTotal(llv->getTotal());
            mapAllTree[curr->artist+'\0'+curr->album] = llv;
        } else {
            lv = new LVI_Album( mapArtistList["AllTree"], curr );
            mapAllTree[curr->artist] = lv;
            lv->setOpen( false );
            llv = new LVI_Album( lv, curr );
            lv->addLocal(llv->getLocal());
            lv->addTotal(llv->getTotal());
            mapAllTree[curr->artist+'\0'+curr->album] = llv;
        }
        lastartist = curr->artist;
    }

    resort(mapArtistList["AllTree"]);

    if (select)
        mapArtistList["AllTree"]->setSelected(mapArtistList["AllTree"]->firstChild() ,true );
    updateStatusBar();
}

void GUI_Selector::notifyNewMediumBasis(QList<MEDIUM> *mediumlist) {
    if(!isConnected)
        return;
    for(MEDIUM *curr = mediumlist->first(); curr != 0; curr = mediumlist->next())
        notifyNewMedium(curr);
}

void GUI_Selector::notifyNewMedium(MEDIUM *medium) {
    if(!isConnected)
        return;

    LVI_Medium *lvi = new LVI_Medium(tabCDROM, medium);
    mapMediumByID[medium->id] = lvi;
    if(lvi->getType() != MEDIUM_HARDDISK) {
        LVI_Medium *curr = mapMediumByID[MEDIUM_HARDDISK];
        while((curr->nextSibling() != 0) && (lvi->key().compare(static_cast<LVI_Medium*>(curr->nextSibling())->key())
                                             > 0)) curr = static_cast<LVI_Medium*>(curr->nextSibling());
        lvi->moveItem(curr);
    }
}

void GUI_Selector::notifyMediumRemoved(int id) {
    if(!isConnected || !mapMediumByID.contains(id))
        return;

    LVI_Medium *lvi = mapMediumByID[id];
    delete lvi;
    localAlbumDelta->remove
    (id);
    mapMediumByID.remove(id);
}

void GUI_Selector::notifyNewLocalAlbumDeltaBasis(QMap<int, QMap<QString, int> > *deltalist) {
    localAlbumDelta = deltalist;
}

void GUI_Selector::notifyNewLocalAlbumDelta(int id, QMap<QString, int> delta) {
    (*localAlbumDelta)[id] = delta;
}

void GUI_Selector::applyLocalAlbumDelta(int id, bool isAvailable) {

    if(!localAlbumDelta->contains(id))
        return;

    QMap<QString, int> *delta = &(*localAlbumDelta)[id];

    int direction = (isAvailable ? 1 : -1);

    for(QMap<QString, int>::Iterator it = delta->
                                          begin();
            it != delta->end();
            ++it) {
        if(mapAllTree.contains(it.key())) { // should always be true
            mapAllTree[it.key()]->changeLocal(direction*it.data());
            //        qWarning("mapAllTree[\"%s\"]->changeLocal(%i*%i)",dumpAllQString(it.key()).local8Bit().data(), direction, it.data());
        }
    }
}

void GUI_Selector::notifySelectArtistAlbum() {
    QListViewItem *lvi;

    if(currentPage() == tabArtists) {
        lvi = mapArtistList["AllTree"]->selectedItem();
    } else {
        lvi = dynamic_cast<QListView*>(currentPage())->selectedItem();
    }

    slot_lviSelected(lvi);

}

void GUI_Selector::notifyNewArtistDelta(QMap<int, QMap<int, DELTAINFO*> > *deltamap) {
    if(!isConnected)
        return;

    if ( verbose == 5) {
        qWarning( "GUI_Selector::notifyNewArtistDelta" );
        dumpdeltamap( deltamap);
    }

    QListViewItem *nextselection = NULL;
    for(QMap<int, QMap<int, DELTAINFO*> >::Iterator it = deltamap->
            begin();
            it != deltamap->end();
            ++it) {
        for(QMap<int, DELTAINFO*>::Iterator it2 = it.data().begin(); it2 != it.data().end(); ++it2) {
            //note: where it.key()=artistID  it2.key()=mediumID it2.data()=deltainfo it3.data() albuminfo

            bool isNewArtist = false;
            if(!mapAllTree.contains(it2.data()->name)) { // add new artist first, then new album(s)
                isNewArtist = true;
                LVI_Album *lvi = new LVI_Album(mapArtistList["AllTree"], it2.data());
                mapAllTree[it2.data()->name] = lvi;
                lvi->setOpen( true );
                nextselection = lvi;
                if(it2.key() != MEDIUM_HARDDISK && localAlbumDelta->contains(it2.key()))
                    (*localAlbumDelta)[it2.key()][it2.data()->name] = it2.data()->total;
                if(it2.key() != MEDIUM_HARDDISK && mapIsAvailable.contains(it2.key()) && mapIsAvailable[it2.key()]) {
                    if (verbose == 5)
                        qWarning("correcting \"%s\" changelocal(%i)", it2.data()->name.local8Bit().data(), it2.data()->total );
                    lvi->changeLocal(it2.data()->total);
                }
                if (verbose == 5)
                    qWarning( "1 adding artist \"%s\"", it2.data()->name.local8Bit().data());

                for( QMap<QString, ALBUMINFO>::Iterator it3 = it2.data()->
                        deltaalbum->begin();
                        it3 != it2.data()->deltaalbum->end();
                        ++it3) {
                    LVI_Album *lvia = new LVI_Album(lvi, it3.data());
                    mapAllTree[ it2.data()->name+'\0'+it3.data().name ] = lvia;
                    if(it2.key() != MEDIUM_HARDDISK && localAlbumDelta->contains(it2.key()))
                        (*localAlbumDelta)[it2.key()][it2.data()->name+'\0'+it3.data().name] = it3.data().total;
                    if(it2.key() != MEDIUM_HARDDISK  && mapIsAvailable.contains(it2.key()) && mapIsAvailable[it2.key()]) {
                        if (verbose == 5)
                            qWarning("correcting \"%s\" changelocal(%i)", dumpAllQString(it2.data()->name+'\0'+it3.data().name).local8Bit().data(), it3.data().total );
                        lvia->changeLocal(it3.data().total);
                    }
                    if (verbose == 5)
                        qWarning( "2 adding album \"%s\" \"%s\"",it2.data()->name.local8Bit().data(), it3.data().name.local8Bit().data());
                }

            } else { // if contains()    remove album(s) first then artist
                LVI_Album *lvi = mapAllTree[it2.data()->name];
                bool existence = lvi->applyDelta(it2.data());
                for( QMap<QString, ALBUMINFO>::Iterator it3 = it2.data()->
                        deltaalbum->begin();
                        it3 != it2.data()->deltaalbum->end();
                        ++it3) {
                    bool isNewAlbum = false;
                    if(!mapAllTree.contains( it2.data()->name+'\0'+it3.data().name)) {
                        isNewAlbum = true;
                        LVI_Album *lvia = new LVI_Album(lvi, it3.data());
                        mapAllTree[it2.data()->name+'\0'+it3.data().name] = lvia;
                        if(it2.key() != MEDIUM_HARDDISK && localAlbumDelta->contains(it2.key()))
                            (*localAlbumDelta)[it2.key()][it2.data()->name+'\0'+it3.data().name] = it3.data().total;
                        if (verbose == 5)
                            qWarning( "3 adding album \"%s\" \"%s\"",it2.data()->name.local8Bit().data(), it3.data().name.local8Bit().data());
                    } else {
                        LVI_Album *lvia = mapAllTree[it2.data()->name+'\0'+it3.data().name];
                        bool albumexistence =lvia->applyDelta(it3.data());
                        if (!albumexistence) {
                            delete lvia;
                            mapAllTree.remove( it2.data()->name+'\0'+it3.data().name );
                            if (verbose == 5)
                                qWarning( "4 removing album \"%s\" \"%s\"",it2.data()->name.local8Bit().data(), it3.data().name.local8Bit().data());
                        }
                    }

                    // correct delta information by medium for album items. Localalbumdata is used to update icons when a media is (un)mounted.
                    if(it2.key() != MEDIUM_HARDDISK && !isNewAlbum) {
                        if(localAlbumDelta->contains(it2.key())) { // should always be true
                            if(!(*localAlbumDelta)[it2.key()].contains(it2.data()->name+'\0'+it3.data().name))
                                (*localAlbumDelta)[it2.key()][it2.data()->name+'\0'+it3.data().name] = it3.data().total;
                            else
                                (*localAlbumDelta)[it2.key()][it2.data()->name+'\0'+it3.data().name] += it3.data().total;
                            if((*localAlbumDelta)[it2.key()][it2.data()->name+'\0'+it3.data().name] == 0)
                                (*localAlbumDelta)[it2.key()].remove(it2.data()->name+'\0'+it3.data().name);
                        }
                    }

                    // correct local value in LVI_album for album items. This will update icon when change is made
                    if(it2.key() != MEDIUM_HARDDISK && mapAllTree.contains(it2.data()->name+'\0'+it3.data().name) && mapIsAvailable.contains(it2.key()) && mapIsAvailable[it2.key()]) {
                        if (verbose == 5)
                            qWarning("correcting \"%s\" changelocal(%i)", dumpAllQString(it2.data()->name+'\0'+it3.data().name).local8Bit().data(), it3.data().total );
                        LVI_Album *lvi = mapAllTree[it2.data()->name+'\0'+it3.data().name];
                        lvi->changeLocal(it3.data().total);
                    }
                } // for ( .. it3...)

                if(!existence) {
                    nextselection = lvi->nextSibling()
                                    ;
                    delete lvi;
                    mapAllTree.remove(it2.data()->name);
                    if (verbose == 5)
                        qWarning( "5 removing artist \"%s\"", it2.data()->name.local8Bit().data());
                } else {
                    nextselection = lvi;
                }
            }   // if else mapalltree contains....

            // correct delta information by medium for artist items. not used at the moment
            if(it2.key() != MEDIUM_HARDDISK && !isNewArtist) {
                if(localAlbumDelta->contains(it2.key())) { // should always be true
                    if(!(*localAlbumDelta)[it2.key()].contains(it2.data()->name))
                        (*localAlbumDelta)[it2.key()][it2.data()->name] = it2.data()->total;
                    else
                        (*localAlbumDelta)[it2.key()][it2.data()->name] += it2.data()->total;
                    if((*localAlbumDelta)[it2.key()][it2.data()->name] == 0)
                        (*localAlbumDelta)[it2.key()].remove(it2.data()->name);
                }
            }

            // correct local value in LVI_album for pure artist items. not used at the moment
            if(it2.key() != MEDIUM_HARDDISK && mapAllTree.contains(it2.data()->name) && mapIsAvailable.contains(it2.key()) && mapIsAvailable[it2.key()]) {
                LVI_Album *lvi = mapAllTree[it2.data()->name];
                lvi->changeLocal(it2.data()->total);
            }
        } // for (.. it2 ..)
    } // for (.. it ..)

    if ( nextselection)
        mapArtistList["AllTree"]->setSelected( nextselection, true );
    delete deltamap;
    updateStatusBar();
    resort(mapArtistList["AllTree"]
          );
}

void GUI_Selector::updateStatusBar() {
    jobman->addJob(new Job_CountData());
}

void GUI_Selector::resort(QListView *lv) {
    lv->sort();

    // If someone has a big collection of files containing an empty
    // artist tag the artist tab takes a long time to open
    // because all these files are diplayed. So we move these files to
    // the bottom of the list. - MK
    if(lv->firstChild() && lv->firstChild()->text(0).isEmpty()) {
        lv->firstChild()->moveItem(lv->lastItem()->parent());
    }
}

// ##############################################
// # clear all data
// ##############################################
void GUI_Selector::clear() {
    QMap<QString, QListView*>::Iterator it = mapArtistList.begin();
    for(; it != mapArtistList.end(); ++it)
        it.data()->clear();
    mapAllTree.clear();
    tabFavourites->clear();
    tabCDROM->clear();
    tabAlbum->clear();
    delete localDelta;
    localDelta = 0;
    rwLock = 0;
}

void GUI_Selector::customEvent( QCustomEvent * e ) {
    QPtrList<QListView> listViewsContainingAlbumCoverThumbnails;
    listViewsContainingAlbumCoverThumbnails.append(mapArtistList["AllTree"]);
    listViewsContainingAlbumCoverThumbnails.append(tabFavourites);
    listViewsContainingAlbumCoverThumbnails.append(tabAlbum);

    if(e->type() == NEWCOVERIMAGEEVENT_CODE) {
        NewCoverImageEvent* ce = static_cast<NewCoverImageEvent*>( e );
        for(QListView *listView = listViewsContainingAlbumCoverThumbnails.first(); listView; listView = listViewsContainingAlbumCoverThumbnails.next()) {
            LVI_Album *lvi_artist = static_cast<LVI_Album*>(listView->firstChild());
            while(lvi_artist && (!lvi_artist->getIsArtist() || lvi_artist->text(0) != ce->getArtist())) {
                lvi_artist = static_cast<LVI_Album*>(lvi_artist->nextSibling());
            }
            if(lvi_artist) {
                LVI_Album *lvi_album = static_cast<LVI_Album*>(lvi_artist->firstChild());
                while(lvi_album && lvi_album->text(0) != ce->getAlbum()) {
                    lvi_album = static_cast<LVI_Album*>(lvi_album->nextSibling());
                }
                if(lvi_album) {
                    lvi_album->adjustIcon(true);
                }
            }
        }
    } else if(e->type() == NEWCOVERIMAGESEVENT_CODE) {
        NewCoverImagesEvent* ce = static_cast<NewCoverImagesEvent*>( e );
        for(QListView *listView = listViewsContainingAlbumCoverThumbnails.first(); listView; listView = listViewsContainingAlbumCoverThumbnails.next()) {
            LVI_Album *lvi_artist = static_cast<LVI_Album*>(listView->firstChild());
            while(lvi_artist) {
                LVI_Album *lvi_album = static_cast<LVI_Album*>(lvi_artist->firstChild());
                while(lvi_album) {
                    lvi_album->adjustIcon(true);
                    lvi_album = static_cast<LVI_Album*>(lvi_album->nextSibling());
                }
                lvi_artist = static_cast<LVI_Album*>(lvi_artist->nextSibling());
            }
        }
    }
}

// *** destructor ***
GUI_Selector::~GUI_Selector() {}
