/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GUI_MIXXXQUEUE_H
#define GUI_MIXXXQUEUE_H

#include "extendedlistview.h"
#include "lvi_track.h"
#include "lvi_playlisttrack.h"

#include <qwidget.h>
#include <qframe.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qptrvector.h>

class GUI_MixxxQueue : public QFrame  {
    Q_OBJECT
public:
    GUI_MixxxQueue(QWidget *parent=0, const char *name=0);

    void setMixxxConnectionState(bool state);
    void enqueueAtChannel(QList<LVI_Track>, int);
    void enqueueAtChannel(QList<LVI_PlaylistTrack>, int);
    void enqueueAtChannel(LVI_PlaylistTrack*, int);

    void notifyFinished(int channel);

    ~GUI_MixxxQueue();

public slots:
    void slot_setConnectionState(bool state);

private:
    QPushButton *ch1_up, *ch1_down, *ch1_jump, *ch1_del, *ch1_clear;
    QPushButton *ch1_play, *ch1_stop, *ch1_pause, *ch1_fwd, *ch1_rew, *ch1_next, *ch1_prev;
    QPushButton *ch2_up, *ch2_down, *ch2_jump, *ch2_del, *ch2_clear;
    QPushButton *ch2_play, *ch2_stop, *ch2_pause, *ch2_fwd, *ch2_rew, *ch2_next, *ch2_prev;
    QPushButton *alternate_play, *alternate_stop, *alternate_pause;
    QCheckBox   *autoCrossFading;

    ExtendedListView *ch1_view, *ch2_view;
    QPtrVector<ExtendedListView> ch_view;
    QPtrVector<LVI_PlaylistTrack> play_lvi;
    QPtrVector<LVI_PlaylistTrack> next_lvi;

    bool isConnected;
    bool isMixxxConnected;
    bool isPaused[2];

    void turnOnChannelControls(bool state);
    void turnOnAlternatePlayControls(bool state);

    QString getFile(LVI_PlaylistTrack *lvi);
    void preloadChannel(int channel);

    void movePlaylistTrackUp(QListView* view);
    void movePlaylistTrackDown(QListView* view);
    void adjustPlayNext(QListViewItem* item);

    void button_play(int channel);
    void button_pause(int channel);
    void button_stop(int channel);
    void button_next(int channel);
    void button_prev(int channel);
    void button_del(int channel);
    void button_clear(int channel);
    void button_jump(int channel);

private slots:
    void slot_movePlaylistTrackUpCh1();
    void slot_movePlaylistTrackUpCh2();
    void slot_movePlaylistTrackDownCh1();
    void slot_movePlaylistTrackDownCh2();
    void slot_button_ch1_jump();
    void slot_button_ch1_del();
    void slot_button_ch1_clear();
    void slot_button_ch1_play();
    void slot_button_ch1_stop();
    void slot_button_ch1_pause();
    void slot_button_ch1_fwd();
    void slot_button_ch1_rew();
    void slot_button_ch1_next();
    void slot_button_ch1_prev();
    void slot_button_ch2_jump();
    void slot_button_ch2_del();
    void slot_button_ch2_clear();
    void slot_button_ch2_play();
    void slot_button_ch2_stop();
    void slot_button_ch2_pause();
    void slot_button_ch2_fwd();
    void slot_button_ch2_rew();
    void slot_button_ch2_next();
    void slot_button_ch2_prev();
    void slot_button_alternate_play();
    void slot_button_alternate_pause();
    void slot_button_alternate_stop();
    void slot_doubleClicked(QListViewItem*);
    void slot_contextMenu(QListViewItem*, const QPoint&, int);
};

#endif
