/*
PsTitle.h
*/

#ifndef __PSTITLE_H
#define __PSTITLE_H

#include "Config.h"
#include "Utils.h"
#include <stdio.h>
#include <stdarg.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <stdlib.h>     
#include <limits.h>
#include <fcntl.h>
#include <signal.h>
#include <netdb.h>
#include <pwd.h>
#include <string.h>
#include <unistd.h>
      

#define SPACELEFT(buf, ptr)      (sizeof buf - ((ptr) - buf))
#define MAXLINE     2048            /* max line length */
#define VA_LOCAL_DECL va_list ap;
#define VA_START(f) va_start(ap, f)
#define VA_END va_end(ap)
#define newstr(s)        strncpy(xalloc(strlen(s) + 1), s, strlen(s)+1)

struct procs
  {
  pid_t   proc_pid;
  char    *proc_task;
  };

#define NO_PID          ((pid_t) 0)
#ifndef PROC_LIST_SEG
# define PROC_LIST_SEG  32              /* number of pids to alloc at a time */
#endif

void dostr (char *str, int cut);
void fmtstr (char *value, int ljust, int len, int maxwidth);
void fmtnum (long value, int base, int dosign, int ljust, int len, int zpad);
void sm_dopr (char *buffer, const char *format, va_list args);
int avsnprintf (char *str, size_t count, const char *fmt, va_list args);
void proc_list_set (pid_t pid, char *task);
char * xalloc (register int sz);
void initsetproctitle (int argc, char **argv, char **envp);
void setproctitle (const char *PREFIX, const char *fmt, ...);
void sm_setproctitle (const char *PREFIX, bool status, const char *fmt, ...);

#endif


