/*
 Copyright (C) 2010 Christian Dywan <christian@twotoasts.de>

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 See the file COPYING for the full license text.
*/

namespace Dexter {

    [DBus (name = "org.elementary.dexterserver")]
    interface DexterService : Object {
        public abstract void edit_contact (string name, string email_address) throws IOError;
        public abstract string get_name (string email_address) throws IOError;
        public abstract string[] autocomplete_contact (string keywords) throws IOError;
        public abstract void show_window () throws IOError;
    }

    public class Dexter : Object {
        DexterService? service = null;
        public Dexter () {
            try {
                service = Bus.get_proxy_sync (BusType.SESSION,
                                              "org.elementary.dexterserver",
                                              "/org/elementary/dexterserver");
                /* Ensure Dexter is running, ignore errors, without is fine */
                Process.spawn_async (null, { "dexter-server" }, null,
                    SpawnFlags.SEARCH_PATH
                  | SpawnFlags.STDOUT_TO_DEV_NULL
                  | SpawnFlags.STDERR_TO_DEV_NULL,
                    null, null);
            } catch (GLib.Error error) {  }
        }
        public void edit_contact (string name, string email_address) {
            try {
                if (service == null)
                    throw new GLib.IOError.FAILED ("Service unavailable");
                service.edit_contact (name, email_address);
            } catch (GLib.Error error) {
                Postler.App.execute_command ("dexter");
            }
        }
        public string? get_name (string email_address) {
            try {
                if (service == null)
                    throw new GLib.IOError.FAILED ("Service unavailable");
                string name = service.get_name (email_address);
                return name != "" ? name : null;
            } catch (GLib.Error error) {
                return null;
            }
        }
        public string[] autocomplete_contact (string keywords) {
            try {
                if (service == null)
                    throw new GLib.IOError.FAILED ("Service unavailable");
                return service.autocomplete_contact (keywords);
            } catch (GLib.Error error) {
                return {};
            }
        }
        public void show_window () {
            try {
                if (service == null)
                    throw new GLib.IOError.FAILED ("Service unavailable");
                service.show_window ();
            } catch (GLib.Error error) {
                Postler.App.execute_command ("dexter");
            }
        }
    }
}

