/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef POLYXEDIT_UI_SEQED_WIDGET_KBD_H
#define POLYXEDIT_UI_SEQED_WIDGET_KBD_H

#include "polyxedit-globals.h"
#include "polyxedit-editctxt.h"



/*
****************************************************************
****** HELPER FUNCTIONS FOR HANDLING THE TYPED KEYBD KEYS ******
****************************************************************
*/
gboolean
polyxmass_seqed_widget_kbd_key_press_event (GtkWidget *widget,
				     GdkEventKey *event,
				     gpointer data);

gboolean
polyxmass_seqed_widget_kbd_key_release_event (GtkWidget *widget,
				       GdkEventKey *event,
				       gpointer data);

gboolean
polyxmass_seqed_widget_kbd_alpha_handler (gchar *key_name,
				   GtkWidget *widget);

gboolean
polyxmass_seqed_widget_kbd_backspace_handler (GtkWidget *widget);      

gboolean
polyxmass_seqed_widget_kbd_delete_handler (GtkWidget *widget);

gboolean
polyxmass_seqed_widget_kbd_right_handler (GtkWidget *widget);

gboolean
polyxmass_seqed_widget_kbd_left_handler (GtkWidget *widget);

gboolean
polyxmass_seqed_widget_kbd_home_handler (GtkWidget *widget);

gboolean
polyxmass_seqed_widget_kbd_end_handler (GtkWidget *widget);

gboolean
polyxmass_seqed_widget_kbd_up_handler (GtkWidget *widget);

gboolean
polyxmass_seqed_widget_kbd_down_handler (GtkWidget *widget);

gboolean
polyxmass_seqed_widget_kbd_page_up_handler (GtkWidget *widget);

gboolean
polyxmass_seqed_widget_kbd_page_down_handler (GtkWidget *widget);

gboolean
polyxmass_seqed_widget_kbd_enter_handler (GtkWidget *widget);




/*
****************************************************************
****** HELPER FUNCTIONS FOR HANDLING THE PARSING OF CODES ******
****************************************************************
*/
gboolean
polyxmass_seqed_widget_kbd_del_last_char_elab_code (GtkWidget *widget);


gboolean
polyxmass_seqed_widget_kbd_echo_elab_code (GtkWidget *widget);


gboolean
polyxmass_seqed_widget_kbd_check_complete_elab_code (GtkWidget *widget);


gboolean
polyxmass_seqed_widget_kbd_force_complete_elab_code (GtkWidget *widget);


gboolean
polyxmass_seqed_widget_kbd_evaluate_code (gchar *code, gint idx,
				   GtkWidget *widget);
















#endif /* ifndef POLYXEDIT_UI_SEQED_KBD_H */
