#lang scribble/doc
@(require "common.ss"
          scribble/struct)

@(define spacer (hspace 1))

@(define-syntax-rule (print-table [expr cons qq wr] ...)
  (*print-table (list (list spacer (scheme expr) spacer (schemeresult cons) spacer (schemeresult qq) spacer (schemeresult wr)) ...)))

@(define (*print-table rows)
   (make-table
    #f
    (cons
     (list (make-flow (list (make-paragraph (list spacer))))
           (make-flow (list @t{Input expression}))
           (make-flow (list (make-paragraph (list spacer))))
           (make-flow (list @t{@onscreen{Constructor}}))
           (make-flow (list (make-paragraph (list spacer))))
           (make-flow (list @t{@onscreen{Quasiquote}}))
           (make-flow (list (make-paragraph (list spacer))))
           (make-flow (list @t{@onscreen{write}})))
     (map (lambda (row)
            (map (lambda (e)
                   (make-flow (list (make-paragraph (list e)))))
                 row))
          rows))))

@title[#:tag "output-syntax"]{Output Printing Styles}

@section-index["printing format"]

Many Scheme languages support a @onscreen{Output Syntax} choice that
determines how evaluation results are printed in the
@tech{interactions window}. This setting also applies to output
generated by calling @scheme[print] explicitly.

The following table illustrates the difference between the different
output styles:

@print-table[
[(cons 1 2) (cons 1 2) `(1 . 2) (1 . 2)]
[(list 1 2) (list 1 2) `(1 2) (1 2)]
['(1 2) (list 1 2) `(1 2) (1 2)]
[(list (void)) (list (void)) `(,(void)) (#,(@schemeresultfont "#<void>"))]
[`(,(void)) (list (void)) `(,(void)) (#,(schemeresultfont "#<void>"))]
[(vector 1 2 3) (vector 1 2 3) (vector 1 2 3) #(1 2 3)]
[(box 1) (box 1) (box 1) #&1]
[(lambda (x) x) (lambda (a1) ...) (lambda (a1) ...) #,(schemeresultfont "#<procedure>")]
['sym 'sym 'sym sym]
[(make-s 1 2) (make-s 1 2) (make-s 1 2) #(struct:s 1 2)]
['() empty `() ()]
[add1 add1 add1 #,(schemeresultfont "#<procedure:add1>")]
[(delay 1) (delay ...) (delay ...) #,(schemeresultfont "#<promise>")]
[(regexp "a") (regexp "a") (regexp "a") #rx"a"]
]

The @as-index{@onscreen{Constructor} output} mode treats
@scheme[cons], @scheme[vector], and similar primitives as value
constructors, rather than functions. It also treats @scheme[list] as
shorthand for multiple @scheme[cons]'s ending with the empty list.
@onscreen{Constructor} output is especially valuable for beginning
programmers, because output values look the same as input values.

The @as-index{@onscreen{Quasiquote} output} mode is like
@onscreen{Constructor} output, but it uses @scheme[quasiquote]
(abbreviated with @litchar{`}) to print lists, and it uses
@scheme[unquote] (abbreviated with @litchar{,}) to escape back to
@onscreen{Constructor} printing as needed. This mode provides the same
benefit as @onscreen{Constructor} output, in that printed results are
expressions, but it is more convenient for many kinds of data,
especially data that represents expressions.

The @as-index{@onscreen{write} output} mode corresponds to traditional
Scheme printing via the @scheme[write] procedure.

The @as-index{@onscreen{current-print} output} mode, when available,
prints results using the value of the @scheme[current-print]
parameter, which allows the programming running in DrScheme to control
its own output format.
