## This script compares a value in a text file against lower and 
##   upper thresholds

MESSAGE (STATUS "INFILE is ${INFILE}")
MESSAGE (STATUS "REGEX is ${REGEX}")
MESSAGE (STATUS "LOWER_THRESH is ${LOWER_THRESH}")
MESSAGE (STATUS "UPPER_THRESH is ${UPPER_THRESH}")

FILE (STRINGS ${INFILE} TEST_OUTPUT REGEX "${REGEX}")
MESSAGE(STATUS "PARSED VALUE=|${TEST_OUTPUT}|")

STRING (REGEX MATCH "${REGEX}" TEST_OUTPUT ${TEST_OUTPUT})
SET (TEST_OUTPUT ${CMAKE_MATCH_1})
MESSAGE(STATUS "PARSED_VALUE=|${TEST_OUTPUT}|")

STRING (LENGTH "${CMAKE_MATCH_1}" MATCH_LENGTH)
IF (MATCH_LENGTH GREATER 0
    AND NOT CMAKE_MATCH_1 LESS ${LOWER_THRESH} 
    AND NOT CMAKE_MATCH_1 GREATER ${UPPER_THRESH})
  MESSAGE("Not an error")
ELSE ()
  MESSAGE(SEND_ERROR "An error")
ENDIF ()
