/*
	 pingpong - Really free server for Amateur Radio convers
	 Copyright (C) 2005 Joop Stakenborg <pg4i@amsat.org>

	 This program is free software; you can redistribute it and/or modify
	 it under the terms of the GNU General Public License as published by
	 the Free Software Foundation; either version 2, or (at your option)
	 any later version.

	 This program is distributed in the hope that it will be useful,
	 but WITHOUT ANY WARRANTY; without even the implied warranty of
	 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the
	 GNU General Public License for more details.

	 You should have received a copy of the GNU General Public License
	 along with this program; if not, write to the Free Software Foundation,
	 Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.	
*/

#include <arpa/inet.h>
#include <errno.h>
#include <glib.h>
#include <netdb.h>
#include <netinet/in.h>
#include <string.h>
#include <sys/socket.h>
#include <unistd.h>
#include "types.h"
#include "net.h"

gint create_server(gint port, gint qlen)
{
	struct sockaddr_in addr;
	gint res, reuse = 1, server_fd;
	size_t arg;
	socklen_t salen;

	arg = sizeof(gint);
	server_fd = socket(PF_INET, SOCK_STREAM, 0);
	if (server_fd == -1) return -1;
	res = setsockopt(server_fd, SOL_SOCKET, SO_REUSEADDR, &reuse, (socklen_t)arg);
	if (res == -1) return -1;

	addr.sin_family = AF_INET;
	addr.sin_addr.s_addr = htonl(INADDR_ANY);
	addr.sin_port = htons((gushort)port);

	salen = (socklen_t)sizeof(struct sockaddr_in);
	res = bind(server_fd, (struct sockaddr *)&addr, salen);
	if (res == -1) return -1;

	res = listen(server_fd, qlen);
	if (res == -1) return -1;

	return server_fd;
}

gint connect_client(gchar *addr, gushort port, void *host)
{
	struct sockaddr_in in;
	struct in_addr inaddr;
	gint client_fd, res;
	socklen_t len;

	client_fd = socket(PF_INET, SOCK_STREAM, 0);
	if (client_fd == -1) return -1;

/*	res = inet_aton(addr, &addr_in.sin_addr);*/
	if (inet_aton(addr, &inaddr) == 0) return -1;

	in.sin_family = AF_INET;	
	in.sin_port = htons(port);

	len = (socklen_t)sizeof(struct sockaddr_in);
	res = connect(client_fd, (struct sockaddr *)&in, len);
	if (res == -1) return -1;

	len = (socklen_t)sizeof(in.sin_addr);
	if (host)
	{
		*(struct hostent **)host = gethostbyaddr((gchar *)&in.sin_addr, len, AF_INET);
	}

	return client_fd;
}
