/*
Copyright (c) 2008-2010
	Lars-Dominik Braun <lars@6xq.net>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#ifndef _CRYPT_KEY_INPUT_H
#define _CRYPT_KEY_INPUT_H

#include <stdint.h>

/* decryption key for last 48 bytes of audio urls
 * search for rpc.input in the decompiled pandora actionscript
 */

const unsigned int in_key_n = 16;

static const uint32_t in_key_p [16 + 2] = {
		0xD825B592, 0xA73D0737, 0x3F7C28AE, 0xF91F7116, 0xEF6B001E, 0xD38524FD,
		0x547F01EC, 0xE9C9DF7C, 0x25DE8E97, 0x9F45FF21, 0x87479245, 0x74A5FE7A,
		0x9D4A1EDB, 0x7EEFCA76, 0x58B117C2, 0x0E7F33BE, 0x1C840B7A, 0x15EEE858
		};

static const uint32_t in_key_s [4][256] = {{
		0x4A0BABBD, 0x46B75CE1, 0xDA4E60D7, 0x62DD8F22, 0x668D7291, 0x70330C71,
		0x8ECE2964, 0xD4D1D24F, 0x2247D3FF, 0x33BD2D83, 0x2A7DF912, 0xB9E711C8,
		0x0E6544DB, 0x3A45B663, 0x8A9AB3DB, 0xD1A18732, 0x12700956, 0x25D9E559,
		0x9A425C80, 0xCE51C1BD, 0x73D8583D, 0x22B93DE3, 0x3FF39FAF, 0x3B2E11F8,
		0xA29731D0, 0x4F2C315F, 0xB46182CA, 0xB28C562E, 0xC37A96D9, 0x8AF05087,
		0x745FB822, 0xEBC3F308, 0x2F40C980, 0xE16657A1, 0xBDECD15A, 0xC9948113,
		0xD13F34A9, 0x526A159F, 0xF5982C49, 0x55E2220D, 0x0EAA7A36, 0x90771A3B,
		0x852D659D, 0xF42B33CE, 0xBC55AB70, 0xD58495F9, 0xA01A146A, 0x146E0960,
		0xDCC3EAFB, 0x45561BA0, 0x978C2955, 0x040E66A1, 0x54A12BDC, 0x86EB78C4,
		0x317B7AB9, 0xC1131F78, 0xBC67C341, 0xF8850A30, 0x26EBAEB3, 0xA21BAB96,
		0xF252C98A, 0xE8B913F2, 0x9237DBF2, 0xC549F051, 0xB37EBAEB, 0xE1BBC775,
		0xC1655D75, 0x630A0946, 0xAEE49047, 0x4EC591BF, 0xB155B99A, 0x2EEC5B73,
		0xDE713B06, 0x12A634B7, 0x13CE8AB7, 0x938D6C99, 0x3596EEE0, 0x500F9066,
		0xF6F80717, 0x40D95E18, 0xC1D47A2E, 0x8DEE1E05, 0xE37E36A2, 0x54C7FFD3,
		0x4AFFB9CF, 0x214CF5B8, 0xAB68B547, 0xB7CC1821, 0x5C7DA859, 0xB2DA7DDF,
		0x846494FA, 0x8CB04D15, 0x1A4A71A2, 0x5FF08D8A, 0x8768DF65, 0x924E2FE3,
		0x04B8109A, 0xE418742A, 0x58CD8113, 0x0EF7AAC9, 0x92B0CF79, 0xB01FBED2,
		0x4DE3CE22, 0x6B779E20, 0x1CF126CF, 0x1789A794, 0xA8463DA6, 0xF3CCE7AC,
		0xD225730A, 0x2D1B121E, 0x3F2C0850, 0xE327010B, 0x56D95881, 0x8639B3AE,
		0x01B3CAEB, 0x1F6F9304, 0x7D4BF367, 0xE4EC20D9, 0x6D05AA51, 0x882B710D,
		0xFC409837, 0x65E212C6, 0xA4C94A87, 0xB11A90AE, 0xB575256C, 0x9C12AF15,
		0x682F72EA, 0xC4C8CE09, 0x43F6C164, 0x4BD015D9, 0x9B9B1FCE, 0x9C108425,
		0x40A8DF10, 0xB0BC8633, 0x974EBB7A, 0xDE6FCE1C, 0xE005634D, 0x708C699E,
		0x7D5BFC2F, 0xBC8D5BD0, 0xF0CCE026, 0xB5F50E04, 0x84124BC7, 0x9A34780C,
		0x34E8E954, 0x64E165A3, 0x3007959D, 0x8DA44C08, 0xAA10D841, 0x7E876AE0,
		0xB6020431, 0x47F4EA6A, 0xF4825054, 0x16C42BDB, 0xD1965562, 0x3777B610,
		0x74B5741E, 0xD60C40D9, 0x3A5EF183, 0x8716250D, 0x91797C4D, 0x01A28965,
		0xF9161DBC, 0x44A9E602, 0xABECEF05, 0xAA90BA96, 0x76607DBD, 0x48BF5BB9,
		0x25840A8A, 0xD1AC56A6, 0x6F9B4274, 0xC56846D3, 0x88CF0D6B, 0x324EEFC0,
		0xEA8304DF, 0xA27E4A81, 0x9AAB617B, 0x3301C499, 0x50E8FF17, 0x67B48F3F,
		0x5AFB3B82, 0xF316F7D3, 0xBA425BB4, 0x083E12F4, 0x1CFAB3DB, 0x78C088A9,
		0x6EC83605, 0xB46D30E9, 0x7A45D4FE, 0x1A31BAD8, 0x29242D72, 0x71EFF75F,
		0x6DCFAC98, 0x79A1261A, 0x3865EEF5, 0x619461A3, 0xC25A0231, 0x750472D2,
		0x7B714CBD, 0x7E57A0B8, 0xB3A7319F, 0x3FDDBEAB, 0xC4A71E85, 0x44D38329,
		0xA21B0851, 0xBD44AE96, 0xFA3AF1D0, 0x3D6766B9, 0xA6884E85, 0xD3C9A0C0,
		0xCAE680FC, 0x41C31A2C, 0x091EDF2D, 0x9EA4E645, 0x1CA034CC, 0xE10DBA18,
		0x922AA9DC, 0x2DC318CB, 0xC49D6F10, 0xEEE7A768, 0x8173DD96, 0x96552598,
		0xAB254BF2, 0xA5BFDEE8, 0x898E4896, 0x049DCDBA, 0x57BDCC74, 0x0F3399A4,
		0x63909424, 0x6FEF1E46, 0x36A47384, 0x51F036DE, 0xAE707EA0, 0xDA83353C,
		0xFB9E7298, 0xF9DCF17E, 0x4F6FEF42, 0x2A41B840, 0x7DCD2662, 0x381FEF90,
		0x1773E656, 0xF6029EC1, 0xB1592A3B, 0x10A656D4, 0x6DDB2E61, 0x8E02EDFE,
		0xE32782EA, 0x973D37F5, 0x1594C629, 0x8B73C632, 0x1680A138, 0x3F5B1228,
		0x8C29E932, 0x49D384A2, 0x02794495, 0x118FF2E5
		}, {
		0xAE22E435, 0xBF7344EB, 0xFBF3614E, 0xB52AF67A, 0x15EC7E8B, 0x0615CD74,
		0x310931B6, 0x069D7297, 0x455368A0, 0xEEB001F7, 0x0E925151, 0xDEB13D62,
		0x939071EE, 0x0BD2D2D2, 0x22AFF084, 0xF3D5BA75, 0xE8B78473, 0xE164B152,
		0x8DD31804, 0x1AABFA34, 0xF1837C1B, 0xF50D14CB, 0x44F64DC6, 0x25C4CAC7,
		0x59A2FE4B, 0x0C9E6026, 0x96A8908C, 0x49C0551E, 0x6C952FD7, 0x24BAEAA2,
		0x6B9DC320, 0x727310AD, 0x09873DE7, 0xA815543B, 0x106743C6, 0xF4CDF032,
		0xFB0208AF, 0xD58B37B0, 0xB8916BBB, 0xF31DC932, 0xB2273875, 0x94BFDD76,
		0x2165879B, 0xA652B81E, 0x584698E4, 0xB42AF09E, 0x4DFF38F3, 0x29845BD7,
		0x14F3B627, 0x5ECA5580, 0xFBDDDBB3, 0xD8392CB3, 0xF6B4FBE5, 0xFDCF2025,
		0x31B61951, 0x9E588D9D, 0x25A07E35, 0xDCA8D140, 0x8C973391, 0x70C83894,
		0x1B2F0DC5, 0x248E1EA0, 0x0760336A, 0x8F8BB40F, 0x0D1A660E, 0x0D1640F6,
		0xA32B1F16, 0x3809890F, 0x82F7F0EA, 0x6CCC940F, 0xB9F2C42E, 0xB661A456,
		0x5901ECB5, 0x76B92DF6, 0x21DB5718, 0xE23F3AED, 0xF94A8A63, 0x89F64664,
		0x7335C780, 0x9FF900EB, 0xAC5D42D8, 0xF6049DC4, 0xB99BED2A, 0x3FE7D758,
		0xDB69E89D, 0xCC9C3333, 0x382BB23F, 0xB07FB181, 0x9B20B744, 0x4E4ECE5D,
		0xED8E3B98, 0x4AB66852, 0x78BCC661, 0xC1D8A28C, 0x71E08EB0, 0x9ECAE411,
		0xA4FD636D, 0xA064969A, 0x185B05EC, 0x54896D93, 0x8110F40B, 0xD4D7E57C,
		0x1E928C46, 0xF9CE1F29, 0x3E72FB51, 0xA79C044C, 0xADB9445E, 0x4AA394F9,
		0x129534D2, 0xDF211944, 0x6267B4DA, 0xF534A6F8, 0xD45D2B3E, 0x5F1894E4,
		0xCC27E376, 0xFE866D4F, 0x956E7C8E, 0x0A630CE7, 0x4734673B, 0xBF8AB871,
		0x432C515F, 0xA2D7B37F, 0xCF48F9F8, 0x31F7209B, 0xB6E792D9, 0x5E136600,
		0xF583A945, 0xAAD4705F, 0xE8E30373, 0xA5E5AB27, 0xCAC6FA4A, 0x48F3A109,
		0xB21A697B, 0x45B9B7F0, 0x2E7BB193, 0x9603F1BB, 0xE0BA7A40, 0xCE7EB62E,
		0x334B24C5, 0x0261817E, 0x4EB792AB, 0xB85BC2B6, 0x6D47D0D9, 0xD2A1433B,
		0x7523942B, 0x39BF5CE7, 0x72223B25, 0xC28F0913, 0xC01CFE44, 0x500F27E5,
		0x055379CB, 0x786C7B08, 0x7C75295A, 0x6294932D, 0xF1B01EF0, 0xE79358F6,
		0x89C4E49F, 0xE7F73D07, 0xEF6FE437, 0xF2CDA93F, 0xB0994E68, 0xADF6AC19,
		0x00925578, 0x06454AF8, 0xCE4628AB, 0x9F983E8C, 0x393E59A4, 0x3896C188,
		0x6A0A5EF5, 0xBA378BF3, 0xD27590ED, 0xCFD20FF9, 0x1728237A, 0x8DABD973,
		0xE22C9842, 0x29A1264B, 0xFFC8569C, 0x17DDEBAA, 0xF9D62958, 0x11028197,
		0xC42BD84F, 0x6F81854B, 0x061FD297, 0xD26BA792, 0x63F71BAA, 0xAD36BDCC,
		0x06262269, 0x5711A1F5, 0xAA746143, 0x75242F8D, 0x5817A84D, 0x639ED1B6,
		0x6D18D6C4, 0x4FFEFE01, 0x0689F6D4, 0x5997D712, 0xD761CF5B, 0x9211216C,
		0x5D8006F3, 0xDDE24FEA, 0x1E60F66B, 0x18D41ABC, 0xDC72B4CB, 0x9FBCBA7D,
		0xEAA807C5, 0x700B7E32, 0xCF4173D6, 0xE354A49E, 0x12EB5466, 0x63DCC4E4,
		0x1DC24D6E, 0x1C9F2A83, 0x3DF6F311, 0xFFA91651, 0x3A1A9645, 0x30D568A4,
		0xC51A55B4, 0xEE032227, 0x0F0A28AC, 0x4516C9B2, 0xD7323F98, 0x547C3B78,
		0x5BCA33E1, 0xF28A15C2, 0xDFFEFAAD, 0xD6E87BBD, 0xE820C21D, 0xFB1C97C3,
		0xE40869F7, 0xD4A167F0, 0x79A2EFFC, 0xD67A0D93, 0xE862FF06, 0x54BCFB17,
		0x3420A670, 0x9219126B, 0x54930637, 0x55E84ED3, 0xA8C4D3C6, 0xFC2C2BD2,
		0x73B116F0, 0xE7A2900C, 0x801E1978, 0xC6741B16, 0xFADB0E61, 0xB5315FC8,
		0x76D1E2BD, 0x2C3452EB, 0x9F42E977, 0xBBE3B7FF, 0x3E5A0B7F, 0x4E1E865A,
		0x24D40A06, 0x202F6EDB, 0x9BAEBAFA, 0x6272D57D
		}, {
		0x72B35463, 0xF3AD17A4, 0x5631E69E, 0x407BBD75, 0x3508A084, 0x88AAF1CE,
		0x4B04905F, 0x2F2FEBE0, 0x09AA8992, 0xDE1EA57A, 0x1FDBFAFD, 0x3827C109,
		0x764DFD38, 0x5C4A2FB0, 0xA1E90138, 0xF4814033, 0xD086FC2A, 0xB388B360,
		0xFEA5D332, 0x47202A75, 0xCD25CB9A, 0xA351B744, 0xB7F4A6B6, 0xEE1658C0,
		0x5016807B, 0x12574F7A, 0xB517B43C, 0x741262F5, 0x6F00F349, 0xDAA44579,
		0xE58B8090, 0x6FC04F54, 0x8451D14A, 0x84C352B4, 0x710C2858, 0x0FE8F84C,
		0xAF5E81F8, 0x0865497B, 0x552638F9, 0x3109EBED, 0x13C29D74, 0x276CB543,
		0x8CA65E96, 0xE983C198, 0xB85CDC58, 0xB522FBCD, 0x21506FF9, 0x8C703690,
		0x322A3026, 0xB87B9BA5, 0x49FF5C4F, 0x3B3E927D, 0xCC9E8227, 0x064CEA69,
		0x88F21343, 0x4EDCB6EC, 0x0F7DA6B8, 0x2ABCEF9C, 0x86866163, 0xBF4B1B4F,
		0x94E0E0E7, 0x8CFE5DF6, 0x4A8D073B, 0x43916370, 0xBCED0841, 0x2D8EF63A,
		0xFEFC6AE8, 0x7A3284CD, 0x51FAE69D, 0x34996231, 0x15599997, 0x5A8D2DF2,
		0xDC8F5265, 0x2B23915D, 0xAC578846, 0x0B9BC885, 0xE5AEF368, 0xE352A2EB,
		0x67330720, 0xFD176A18, 0x78BB578F, 0xB5422A51, 0x68F35707, 0x47570020,
		0x8A4F5321, 0xB6774AB5, 0x06CE136C, 0xADED4447, 0xAE8A1FEE, 0xB97BAB2D,
		0x95B81706, 0x493E002C, 0x0D9DC930, 0xF70BF46D, 0x229C90F8, 0xAF450341,
		0x12B799C0, 0x98656508, 0x8C8D6417, 0x491D1ED4, 0x1AF33256, 0xF3275DE1,
		0x08454958, 0x321A8D4E, 0x4F516FE5, 0x1D076087, 0x94311B59, 0xED369CB9,
		0x4FF94F65, 0x87129FB4, 0x8D065220, 0x7B11F2D5, 0x976138B0, 0x030962FB,
		0x8E68ED5F, 0xE26B5272, 0x045BCBEB, 0x9350F121, 0x522DDFEB, 0x1EEB70B2,
		0xCC2EABF8, 0x22BA4ED7, 0x30B0C3BC, 0x64DF8A4C, 0xF58B3FF2, 0x56B3BBE6,
		0x3E71A700, 0x65D765C7, 0x87A50635, 0x9156084B, 0x85CD7CAA, 0x7BFF8FFF,
		0x7B79A939, 0x69277DCA, 0x5A7C5DF2, 0x37886A35, 0x177CA1B3, 0x96871FD4,
		0xB869BA3D, 0x1C2697A1, 0xD59109DD, 0x6B870F45, 0xC9ADBA95, 0xDB8323D8,
		0x0A777311, 0x25E2DF2D, 0x18C684D7, 0x645521B0, 0x58ABD6FC, 0x7EC9EF2D,
		0x11B4DB17, 0xAE1A2EE9, 0x84E961A4, 0x1627F703, 0x8C23EC6D, 0xF0A8A31C,
		0x8E53A703, 0xB1131710, 0x5723CF12, 0x991DF0FF, 0xA30498B8, 0x02EF0D79,
		0x2B3DD3EF, 0xD38C2931, 0xE5745386, 0xF41AE34F, 0x10499E3C, 0xF79569CE,
		0x8ED71CA2, 0x98B0DC30, 0x9F6E5321, 0x42EB67BA, 0x2742BCEC, 0x8DF9EF50,
		0xAAA09BA7, 0xF9695506, 0xA294E5EF, 0xDC12C945, 0x0F7A7CEA, 0x9E19DD96,
		0xABD27434, 0xD26E3C3F, 0x13B45FF0, 0xCF8379E7, 0xF85FF493, 0x985079D6,
		0xBDB81502, 0xA2C60C5C, 0x22B632AC, 0x3D3986EE, 0x45825465, 0xAEEB58F9,
		0xF283D84B, 0x80517003, 0x942B1C72, 0xE3E70F85, 0x3F8E843D, 0x7454E06D,
		0x31B2159B, 0x568A8365, 0x23DCC43E, 0x37871B58, 0x60C69863, 0xD1889242,
		0x520946C2, 0x929B3286, 0xD95FED2C, 0x2A208340, 0x928DF232, 0xC028DF59,
		0x0D35A23F, 0x00EDC91C, 0x3979AED9, 0xAA29C007, 0x84BA7B37, 0x7E3CA9CB,
		0x54F00B03, 0x61691F7C, 0x5834387D, 0x770BB788, 0xB162F9C0, 0x43618701,
		0x9E059974, 0x06E5F826, 0x0CF7163D, 0xBBE0FE4D, 0x7F106BA3, 0x71A5CDA3,
		0x7044BD36, 0x54DB9C6D, 0xCEB6C2E7, 0x4DE29FAE, 0x136CB930, 0xEA408A55,
		0x7ADB6970, 0xC89057DA, 0x70B27C55, 0xFD9DD49F, 0x71945289, 0x29F6F8CA,
		0xDFD414FF, 0x3A073C7A, 0x610CB803, 0xF63DB2F3, 0xDAB51606, 0x1D98C2CB,
		0x8EAED1E3, 0x2713BE03, 0xA7740897, 0x4184FD27, 0xF4FB8A06, 0x42B5EE24,
		0x16CC60A1, 0x58C7FA50, 0x0D3A4CB4, 0x40C16EFA
		}, {
		0xF0B6672A, 0x2FBFF845, 0xF8DAE2E1, 0x1E62ADD9, 0xE386B139, 0xCE326446,
		0x1F85E0A2, 0x876AC684, 0xF89F69ED, 0xB9C1F96B, 0x0F350297, 0x5D5C5727,
		0xE4D11EDE, 0xCB7964CC, 0xE1646E44, 0x413DB994, 0x50169691, 0x2A75843F,
		0xE56CE654, 0x307C49E8, 0xABBF759E, 0x18E30B64, 0x1DBD8903, 0xED9C2D59,
		0x2DDFF02B, 0x6EF2C41D, 0x3FF08CED, 0x5C4B7F31, 0xB26984CA, 0xB0B1EFEA,
		0x9C11734E, 0x680B8B66, 0xDC671C46, 0x2F8DD9C2, 0xCACF3975, 0xC3F6D8DB,
		0x38DDF820, 0x421E0652, 0x9FBE5AFA, 0xB4F43AE3, 0x957FC205, 0xFFA58375,
		0x55286205, 0x7EE974B5, 0x31DECAF4, 0x3E7425ED, 0xACD2BC1B, 0xFBB39E17,
		0xE99CE668, 0xC3DE689F, 0xE8BC3A39, 0xC327F086, 0xB3F2E894, 0x13CDC849,
		0xA7D8DACF, 0x2987F368, 0x7FC52A15, 0x2C0DE867, 0xC39020AE, 0x6B9A5BEB,
		0x1116EB0C, 0x56FAD5FD, 0xE13E5C39, 0x167F6C42, 0x1462F7F4, 0x5D1875F4,
		0x82A56F78, 0x2DFB88E6, 0xD0191186, 0x0850D44A, 0xCEFA0FC4, 0x3FB97E0B,
		0x3225B980, 0x3D33D41F, 0x595FA8D5, 0x3FB1945B, 0x94D5E9FA, 0xDDEF2BCB,
		0x4C35A2D9, 0xCF328015, 0x7DEEB93C, 0xF76A0735, 0x6CBE97D8, 0xE1E32FD2,
		0x72537C1C, 0x6946111C, 0x689A0958, 0x2A82EBAD, 0x5A70B4F6, 0xCA2C98CF,
		0x500B4CB5, 0xE4F72532, 0x317ABF2E, 0x9B16512E, 0x612F8F0B, 0xBF323BE6,
		0x7A9A4827, 0xE401B548, 0x4776626E, 0xCB602107, 0xEC189B17, 0x94A36CB9,
		0x00C86686, 0xDA12464F, 0x0172E4EC, 0x9779E7E2, 0x45349B40, 0x7286BCE1,
		0x1913C435, 0x8BF1E440, 0x16BB54D3, 0xE700E633, 0xF524785A, 0xB27F3F09,
		0x25B6406D, 0xA19BF68C, 0x3B144DA2, 0x816B70C0, 0xFF86B5D6, 0x1E75EBB3,
		0x57B4F242, 0x46771F2A, 0x53776C5F, 0x6257CECD, 0x27D7A26B, 0x74AD749F,
		0x0E8DF172, 0xFA7C4A26, 0x8F978578, 0xF3265767, 0xA08160FB, 0x8A13431D,
		0x22213265, 0x4A018EF2, 0x526BB8F8, 0x5FC7F38C, 0xFAB62CD2, 0x50EF8674,
		0x3E4FC6E1, 0x08553D35, 0x2BCC6BD6, 0x06D22116, 0x25F16EE8, 0xB51D172B,
		0x8E657082, 0xD102410A, 0x6B8DE05D, 0x22AEA76E, 0x0B692D8D, 0xC5E7C0F1,
		0xB3499478, 0xAB3AE1FF, 0xC16DCFB5, 0xB5F67469, 0x31C015AE, 0x7807E2FF,
		0x67E17C48, 0x56BB3693, 0xB11ABE01, 0x4AC2383A, 0x54D6BFDF, 0xBA1F540E,
		0xF4CEFE7B, 0x7F9CD102, 0x82C1AB14, 0x4D32978E, 0xE3832FE2, 0x1E63A9AA,
		0xCB1BB7CB, 0x478E6C6D, 0xD8C0CB68, 0xB907DA30, 0x05BC439C, 0x79872F07,
		0x74040F93, 0x5EE6EABD, 0xC700C640, 0xE2740CF2, 0x7D9611A6, 0x28C34433,
		0x9519AF00, 0xACAE30BA, 0xD1ED6770, 0x72557C82, 0x50D9BCCD, 0xBCDEE88E,
		0x97E36EFF, 0xCC382EF8, 0x71B71FC2, 0x6EED0311, 0x17B065C2, 0x38BE59A6,
		0x6D47222A, 0x9940BBDD, 0x342463F0, 0x98723D62, 0x59EC6C09, 0x13E077BB,
		0x6CDD2887, 0x763D4A95, 0x51D7A260, 0x7615C8BF, 0x7BAA1B0D, 0x85E2F0B8,
		0x29A14FB7, 0x90BC2A4F, 0x15A17CE1, 0x95BBC7DA, 0x98384B5B, 0x964E6B18,
		0x1341FD22, 0x64BC571D, 0x856E353D, 0x92846808, 0xBDBC4F81, 0x11C5A93F,
		0x9B00D8AB, 0xE9C7F68C, 0x002C42BE, 0x79B7F2E8, 0xCC450F36, 0x106D1921,
		0x8306ECBF, 0xB3E092E3, 0xFB4A2813, 0xC46D7B9F, 0x7CF4F348, 0x1BEB4962,
		0xFEC844F2, 0xD5FE7D0A, 0xF28A1872, 0xA0E433FE, 0x5EDB808D, 0x01591BE1,
		0xDB4E08F3, 0x298A0DFB, 0xC638BB36, 0x59F96184, 0xA344CD21, 0x39BAFAD3,
		0x83112A1C, 0x1892FC88, 0x856E9D5C, 0x13FD4F16, 0x81802AB7, 0x79FB698E,
		0xAB8AF3E1, 0x986C72C1, 0xF1565939, 0x332EFF7D, 0xD0D7746C, 0xDCF7CA0E,
		0x61E6931A, 0xF582D866, 0x2C3410D9, 0x21D70463
		}};

#endif /* _CRYPT_KEY_INPUT_H */
