# -*- coding: UTF-8 -*-

# Phatch - Photo Batch Processor
# Copyright (C) 2007-2008  www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/

import gettext, glob, locale, os, sys
from lib.unicoding import ensure_unicode

USER_PATH       = os.path.expanduser('~')
try:
    USER_PATH   = USER_PATH.decode(sys.getfilesystemencoding())
except:
    pass
APP_USER_PATH       = os.path.join(USER_PATH,'.phatch')
USER_ACTIONS_PATH   = os.path.join(APP_USER_PATH,'actions')
USER_FONTS_PATH     = os.path.join(APP_USER_PATH,'fonts')
USER_MASKS_PATH     = os.path.join(APP_USER_PATH,'masks')
USER_WATERMARKS_PATH    = os.path.join(APP_USER_PATH,'watermarks')

def check_config_paths(config_paths):
    global SYSTEM_INSTALL
    if config_paths: 
        SYSTEM_INSTALL  = False
        return config_paths
    SYSTEM_INSTALL  = True
    p   = sys.prefix
    if sys.platform[:5] == 'linux':
        return {
            "PHATCH_IMAGE_PATH" : os.path.join(p,"share","phatch","images"),
            "PHATCH_LOCALE_PATH": os.path.join(p,"share","locale"),
            "PHATCH_DOCS_PATH"  : os.path.join(p,"share","phatch","docs"),
            "PHATCH_ACTIONLISTS_PATH": os.path.join(p,"share","phatch","actionlists"),
        }
    else:
        sys.stderr.write('Sorry your platform is not yet supported.\n')
        sys.exit()
        
def add_user_paths(config_paths):
    config_paths["USER_PATH"]           = USER_PATH
    config_paths["APP_USER_PATH"]       = APP_USER_PATH
    config_paths["USER_ACTIONS_PATH"]   = USER_ACTIONS_PATH
    config_paths["USER_FONTS_PATH"]     = USER_FONTS_PATH
    config_paths["USER_MASKS_PATH"]     = USER_MASKS_PATH
    config_paths["USER_WATERMARKS_PATH"]= USER_WATERMARKS_PATH

def fix_python_path(phatch_python_path=None):
    if not phatch_python_path:
        phatch_python_path = os.path.dirname(
            os.path.dirname(os.path.abspath(__file__)))
    if not(phatch_python_path in [ensure_unicode(x) for x in sys.path]):
        sys.path.insert(0,phatch_python_path)
    return phatch_python_path

def load_locale(app,path,canonical='default',unicode=True):
    locale.setlocale(locale.LC_ALL, '')
    #get default canonical if necessary
    if canonical == 'default':
        canonical  = locale.getdefaultlocale()[0]#canonical
        if canonical is None:
            #for mac
            canonical   = 'en'
    #canonical = 'zh' #to test unicode languages
    #expand with similar translations
    languages   = [os.path.basename(x) for 
                    x in glob.glob(os.path.join(path,canonical[:2]+'*'))]
    if canonical in languages:
        languages.remove(canonical)
    languages.insert(0,canonical)
    #install
    i18n = gettext.translation(app, path, languages=languages,fallback=1)
    i18n.install(unicode=unicode)

def init_config_paths(config_paths={}):
    #check paths
    config_paths    = check_config_paths(config_paths)
    add_user_paths(config_paths)
    #configure sys.path
    phatch_path     = fix_python_path(
                        config_paths.get("PHATCH_PYTHON_PATH",None))
    fix_python_path(os.path.join(phatch_path,'core','lib'))
    #only when the gui is involved
    pyWxLib         = os.path.join(phatch_path,'pyWx','lib')
    if os.path.isdir(pyWxLib): fix_python_path(pyWxLib)
    #other people module (patches for pil)
    fix_python_path(os.path.join(phatch_path,'other'))
    #user actions
    fix_python_path(USER_ACTIONS_PATH)
    #load locale
    #load_locale('phatch',config_paths["PHATCH_LOCALE_PATH"])
    #set font cache
    from fonts import set_font_cache
    set_font_cache(USER_FONTS_PATH)
    #register paths
    global PATHS
    PATHS   = config_paths
    #return values
    return config_paths
    
def load_locale_only(config_paths={}):
    config_paths    = check_config_paths(config_paths)
    load_locale('phatch',config_paths["PHATCH_LOCALE_PATH"])
    
