import sys, os, glob
import unittest
import petsc4py

if '-petsc' in sys.argv:
    idx = sys.argv.index('-petsc')
    args = sys.argv[idx+1:]
    del sys.argv[idx:]
    petsc4py.init(args)
    del idx, args

from petsc4py import PETSc

version = PETSc.Sys.getVersion()
exclude = {'test_import':   True,
           'test_initfini': True,
           'test_log':      (2,3,2),
           }
           
directory = os.path.split(__file__)[0]
pattern = os.path.join(directory, 'test_*.py')
test_cases = []
for test_file in glob.glob(pattern):
    filename = os.path.basename(test_file)
    name = os.path.splitext(filename)[0]
    if name in exclude:
        if exclude[name] is True or \
           exclude[name] == version:
            continue
    test = __import__(name)
    test_cases.append(test)

for test in test_cases:
    try:
        unittest.main(test)
    except SystemExit:
        pass
