/*
 * window_main_permission.h
 * Copyright (C) Martin Singer 2009-2011 <m_power3@users.sourceforge.net>
 * 
 * pdfchain is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * pdfchain is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PDFCHAIN_WINDOW_MAIN_PERMISSION_H
#define PDFCHAIN_WINDOW_MAIN_PERMISSION_H

#include "pdfchain.h"


/*** Expander : Permission ****************************************************/

class
cExpander_Permissions : public Gtk::Expander
{
	public:

		cExpander_Permissions();
		virtual ~cExpander_Permissions();

		void clear();
		Glib::ustring createCommand();

	protected:

		Gtk::HBox				mHBox_Permissions;
		Gtk::VBox				mVBox_Passwords,
								mVBox_Encryption;
		Gtk::Table				mTable_Features;
		Gtk::Frame				mFrame_Features,
								mFrame_PasswordOwner,
								mFrame_PasswordUser,
								mFrame_Encryption;
		Gtk::CheckButton		mCButton_Printing,
								mCButton_DegradedPrinting,
								mCButton_ModifyContents,
								mCButton_Assembly,
								mCButton_CopyContents,
								mCButton_Screenreaders,
								mCButton_ModifyAnnotations,
								mCButton_FillIn;
		Gtk::RadioButton		mRButton_EncryptNone,
								mRButton_Encrypt40Bit,
								mRButton_Encrypt128Bit;
		Gtk::Entry				mEntry_PasswordOwner,
								mEntry_PasswordUser;
		Gtk::RadioButtonGroup	mRBGroup_Encrypt;
		Gtk::Alignment			mAlign_PasswordOwner,
								mAlign_PasswordUser,
								mAlign_Permissions;

		void init();

		void onEntryIcon_PasswordOwner_pressed( Gtk::EntryIconPosition icon_pos , const GdkEventButton* event ) {
			mEntry_PasswordOwner.set_text("");
			return;
		}

		void onEntryIcon_PasswordUser_pressed( Gtk::EntryIconPosition icon_pos , const GdkEventButton* event ) {
			mEntry_PasswordUser.set_text("");
			return;
		}
};


#endif