/*******************************************
 PDF Chain
 
 Copyright: 2009 Martin Singer
 <http://sourceforge.net/projects/pdfchain/>
 
 Author: Martin Singer
 <m_power3@users.sourceforge.net>
 
 License: GPL version 3+
 <http://www.gnu.org/licenses/>
 
 MainWindow
 src/mainwindow.hh
 *******************************************/

#ifndef PDF_CHAIN__WINDOW_WINDOW
#define PDF_CHAIN__WINDOW_WINDOW

#include "definings.hh"
#include "dialogs.hh"
#include "filechoosers.hh"
#include "extract.hh"
#include "compress.hh"
#include "dump_data_fields.hh"
#include "dump_data.hh"
#include "update_info.hh"
#include "generate_fdf.hh"
#include "fill_form.hh"
#include "flatten.hh"
#include "drop_xfa.hh"
#include "merge_options.hh"

/*** Class ***/
class class_window_main : public Gtk::Window{
	
  public:
		
	class_window_main();
	virtual ~class_window_main(){
			
		delete pt_menubar;
	}
		
  protected:
		
	// Inner Classes
	/*** Class class_window_main::class_treeview_merge ***/
	class class_treeview_merge : public Gtk::TreeView{
			
	  public:
				
		// Constructor / Destructor (inline)
		class_treeview_merge();
		~class_treeview_merge(){}

		// Inner Class
		/*** Class class_window_main::class_treeview_merge::class_treemodel_merge ***/
		class class_treemodel_merge : public Gtk::TreeModel::ColumnRecord{
					
		  public:
						
			// Constructor (inline)
			class_treemodel_merge(){
							
				add(column_add);
				add(column_pages);
				add(column_evenodd);
				add(column_rotation);
				add(column_sourcepath);
				add(column_password);
				add(column_sourcefile);
				add(column_filepages);
			}
						
			// Destructor (inline)    
			~class_treemodel_merge(){}
						
			// Widgets
			Gtk::TreeModelColumn<bool>          column_add;
			Gtk::TreeModelColumn<Glib::ustring> column_pages;
			Gtk::TreeModelColumn<Glib::ustring> column_evenodd;
			Gtk::TreeModelColumn<Glib::ustring> column_rotation;
			Gtk::TreeModelColumn<Glib::ustring> column_sourcepath;
			Gtk::TreeModelColumn<Glib::ustring> column_password;
			Gtk::TreeModelColumn<Glib::ustring> column_sourcefile;
			Gtk::TreeModelColumn<Glib::ustring> column_filepages;
		};
				
		// Windows (Public)
		class_window_merge_options window_merge_options;					// Should be Protected !!!
			
		// Widgets (Public)
		Glib::RefPtr<Gtk::ListStore>
			ref_liststore_merge;											// Should be Protected !!!
				
		class_treemodel_merge
			treemodel_merge;												// Should be Protected !!!
				
		// Methodes (Public)
		void set_parent(class_window_main*);
		void set_dialogs(class_dialogs*);
		void clear();
				
		void row_up();
		void row_down();
		void row_add();
		void row_copy();
		void row_remove();
				
		int count_sourcefiles();
				
		// Signal Handlers (Public)
		virtual void on_cursor_changed();
				
				
	  protected:
				
		// Windows
		class_window_main* pt_parent;
		class_dialogs*     pt_dialogs;
		//class_window_merge_options window_merge_options;
				
		// Widgets
		Gtk::HBox 
			hbox_evenodd_all,
			hbox_evenodd_even,
			hbox_evenodd_odd,
			hbox_rotation_0,
			hbox_rotation_90,
			hbox_rotation_180,
			hbox_rotation_270,
			hbox_up,
			hbox_down,
			hbox_add,
			hbox_copy,
			hbox_remove;
				
		Gtk::Menu
			popupmenu;
				
		Gtk::MenuItem
			menuitem_evenodd_all,
			menuitem_evenodd_even,
			menuitem_evenodd_odd,
			menuitem_rotation_0,
			menuitem_rotation_90,
			menuitem_rotation_180,
			menuitem_rotation_270,
			menuitem_up,
			menuitem_down,
			menuitem_add,
			menuitem_copy,
			menuitem_remove;
				
		// Methodes
				
		// Signal Handlers
		virtual bool on_button_press_event(GdkEventButton*);
		virtual void on_popupmenu_evenodd_all();
		virtual void on_popupmenu_evenodd_even();
		virtual void on_popupmenu_evenodd_odd();
		virtual void on_popupmenu_rotation_0();
		virtual void on_popupmenu_rotation_90();
		virtual void on_popupmenu_rotation_180();
		virtual void on_popupmenu_rotation_270();
	
		// Signal Handlers -> Friend Classes -> Buttons
		virtual void on_button_window_merge_options_set();
		virtual bool on_window_merge_options_quit(GdkEventAny*);
	};
		
		
	// Inner Class
	/*** Class class_window_main::class_treeview_attachments ***/
	class class_treeview_attachments : public Gtk::TreeView{
		
	  public:
		
		class_treeview_attachments();
		~class_treeview_attachments(){}
			
		// Inner Class
		/*** Class class_window_main::class_treeview_attachments::class_treemodel_attachments ***/
		class class_treemodel_attachments : public Gtk::TreeModel::ColumnRecord{
			
		  public:
				
			// Constructor (inline)
			class_treemodel_attachments(){
				add(column_add);
				add(column_attachpath);
				add(column_attachfile);
			}
				
			~class_treemodel_attachments(){}
				
			// Widgets
			Gtk::TreeModelColumn<bool>          column_add;
			Gtk::TreeModelColumn<Glib::ustring> column_attachpath;
			Gtk::TreeModelColumn<Glib::ustring> column_attachfile;
		};
			
		// Widgets (Public)
		Glib::RefPtr<Gtk::ListStore>
			ref_liststore_attachments;											// Should be Protected !!!
				
		class_treemodel_attachments
			treemodel_attachments;												// Should be Protected !!!
				
		// Methodes (Public)
		void set_parent(class_window_main*);
		void set_dialogs(class_dialogs*);
		void clear();
				
		void row_up();
		void row_down();
		void row_add();
		void row_copy();
		void row_remove();
			
			
			
	  protected:

		// Windows
		class_window_main* pt_parent;
		class_dialogs*     pt_dialogs;
			
		// Widgets
		Gtk::HBox 
			hbox_up,
			hbox_down,
			hbox_add,
			hbox_copy,
			hbox_remove;
				
		Gtk::Menu
			popupmenu;
				
		Gtk::MenuItem
			menuitem_up,
			menuitem_down,
			menuitem_add,
			menuitem_remove;
			
		// Methodes
				
		// Signal Handlers
		virtual bool on_button_press_event(GdkEventButton*);
	};
		

		
		
	// Windows
	class_dialogs dialogs;
	class_window_tools_extract window_tools_extract;
	class_window_tools_compress window_tools_compress;
	class_window_tools_dump_data_fields window_tools_dump_data_fields;
	class_window_tools_dump_data window_tools_dump_data;
	class_window_tools_update_info window_tools_update_info;
	class_window_tools_generate_fdf window_tools_generate_fdf;
	class_window_tools_fill_form window_tools_fill_form;
	class_window_tools_flatten window_tools_flatten;
	class_window_tools_drop_xfa window_tools_drop_xfa;


	// Variables
	Glib::ustring
		ustring_split_sourcefile,        // Sourcefilename (without path)
		ustring_split_pages,             // Pages of Sourcefile
		ustring_stamp_sourcefile,        // (used at Statusbar)
		ustring_stamp_pages,
		ustring_attachments_sourcefile,
		ustring_attachments_pages;
		
		
	// Widgets Options
	Gtk::Alignment
		alignment_merge_buttons,
		alignment_merge_options,
		alignment_attachments_buttons,
		alignment_attachments_filepage,
		alignment_stamp_selectionframe;

	Gtk::Adjustment
		adjustment_split_digits,         // for Spinbuttons
		adjustment_attachments_page;
	
	Gtk::RadioButton::Group
		group_radiobutton_stamp,
		group_radiobutton_split,
		group_radiobutton_attachments,
		group_radiobutton_encryption;
	
	// Widgets
	Glib::RefPtr<Gtk::UIManager>
		ref_uimanager_window_main;
	
	Glib::RefPtr<Gtk::ActionGroup>
		ref_menu_window_main;
	
	Gtk::Widget
		*pt_menubar;
	
	Gtk::ScrolledWindow
		scrolledwindow_merge,
		scrolledwindow_attachments;
	
	class_treeview_merge
		treeview_merge;
	
	class_treeview_attachments
		treeview_attachments;
	
	Gtk::Notebook
		notebook;
	
	Gtk::Expander
		expander_permissions;
	
	Gtk::Table
		table_split_options,
		table_rights,
		table_encryption;

	Gtk::VBox
		vbox_window, vbox_content,
		vbox_merge,
		vbox_split,
		vbox_stamp,
		vbox_attachments,
		vbox_permissions_passwords,
		vbox_passwords;
	
	Gtk::HBox
		hbox_merge,
		hbox_merge_buttons,
		hbox_merge_options,
		hbox_stamp,
		hbox_split_sourcefile,
		hbox_split_prefix,
		hbox_split_digits,
		hbox_stamp_sourcefile,
		hbox_stamp_background,
		hbox_stamp_selection,
		hbox_stamp_selectionframe,
		hbox_attachments,
		hbox_attachments_sourcefile,
		hbox_attachments_buttons,
		hbox_attachments_filepage,
		hbox_permissions,
		hbox_passwords_ownerpassword,
		hbox_passwords_userpassword,
		hbox_save;
	
	Gtk::Frame
		frame_split_sourcefile,
		frame_split_prefix,
		frame_split_digits,
		frame_stamp_sourcefile,
		frame_stamp_background,
		frame_stamp_selection,
		frame_attachments_sourcefile,
		frame_save,
		frame_rights,
		frame_permissions,
		frame_encryption,
		frame_passwords_ownerpassword,
		frame_passwords_userpassword;
	
	Gtk::VSeparator 
		vseparator_merge1,
		vseparator_merge2,
		vseparator_attachments;
	
	Gtk::Entry
		entry_split_sourcefile,
		entry_split_prefix,
		entry_stamp_sourcefile,
		entry_stamp_background,
		entry_attachments_sourcefile,
		entry_passwords_userpassword,
		entry_passwords_ownerpassword;
	
	Gtk::ComboBoxText
		combobox_merge_id;
	
	Gtk::Button
		button_merge_up,
		button_merge_down,
		button_merge_copy,
		button_merge_add,
		button_merge_remove,
		button_split_sourcefile,
		button_stamp_sourcefile,
		button_stamp_background,
		button_attachments_up,
		button_attachments_down,
		button_attachments_add,
		button_attachments_remove,
		button_attachments_sourcefile,
		button_save;
	
	Gtk::ToggleButton
		button_merge_options;
	
	Gtk::CheckButton
		checkbutton_rights_printing,
		checkbutton_rights_degradedprinting,
		checkbutton_rights_modifycontents,
		checkbutton_rights_assembly,
		checkbutton_rights_copycontents,
		checkbutton_rights_screenreaders,
		checkbutton_rights_modifyannotations,
		checkbutton_rights_fillin;
	
	Gtk::RadioButton
		radiobutton_stamp_background,
		radiobutton_stamp_stamp,
		radiobutton_split_auto,
		radiobutton_split_manual,
		radiobutton_encryption_none,
		radiobutton_encryption_40bit,
		radiobutton_encryption_128bit,
		radiobutton_attachments_page,
		radiobutton_attachments_file;
	
	Gtk::SpinButton
		spinbutton_split_digits,
		spinbutton_attachments_page;
	
	Gtk::ProgressBar
		progressbar_save;
	
	Gtk::Statusbar
		*pt_statusbar;
	
	
	// Signal Handlers
	// Signal Handlers -> Menus
	virtual void on_menu_file_new();
	virtual void on_menu_file_quit();
	virtual void on_menu_help_help();
	virtual void on_menu_help_about();
	
	virtual void on_menu_tools_extract();
	virtual void on_menu_tools_compress();
	virtual void on_menu_tools_dump_data_fields();
	virtual void on_menu_tools_dump_data();
	virtual void on_menu_tools_update_info();
	virtual void on_menu_tools_generate_fdf();
	virtual void on_menu_tools_fill_form();
	virtual void on_menu_tools_flatten();
	virtual void on_menu_tools_drop_xfa();
	
	// Signal Handlers -> Window
	virtual bool on_quit(GdkEventAny*);
	virtual bool on_window_merge_options_quit(GdkEventAny*);
	
	// Signal Handler -> Notebook
	virtual void on_notebook_switch_page(GtkNotebookPage*, guint);
	
	// Signal Handlers -> Buttons
	virtual void on_button_merge_up();
	virtual void on_button_merge_down();
	virtual void on_button_merge_add();
	virtual void on_button_merge_copy();
	virtual void on_button_merge_remove();
	virtual void on_button_merge_options();
	virtual void on_button_attachments_sourcefile();
	virtual void on_button_attachments_up();
	virtual void on_button_attachments_down();
	virtual void on_button_attachments_add();
	virtual void on_button_attachments_remove();
	virtual void on_button_split_sourcefile();
	virtual void on_button_stamp_sourcefile();
	virtual void on_button_stamp_background();
	virtual void on_button_save();
	
	
	// Methods
	void save_merge();
	void save_split();
	void save_stamp();
	void save_attachments();
	Glib::ustring save_set_rights();
	
	void push_status(Pdfchain::Selection);
	void clear();
};

#endif
