/*******************************************
 PDF Chain
 
 Copyright: 2009 Martin Singer
 <http://sourceforge.net/projects/pdfchain/>
 
 Author: Martin Singer
 <m_power3@users.sourceforge.net>
 
 License: GPL version 3+
 <http://www.gnu.org/licenses/>
 
 Dialogs
 src/filechoosers.hh
 *******************************************/

#ifndef PDF_CHAIN__DIALOGS_FILECHOOSERS
#define PDF_CHAIN__DIALOGS_FILECHOOSERS

#include "definings.hh"
#include "dialogs.hh"

/*** Class ***/
class class_filechoosers{
	
	public:
		
		// Constructors
		class_filechoosers(Gtk::Window*, Pdfchain::FileChooserType);
		class_filechoosers(Gtk::Window*, Pdfchain::FileChooserType, Pdfchain::FileFilterType);
		class_filechoosers(Gtk::Window*, Pdfchain::FileChooserType, Pdfchain::FileFilterType, Pdfchain::FileFilterType);
		virtual ~class_filechoosers();
		
		// Methodes
		Glib::ustring run();
		Gtk::FileChooserDialog* run_multiple();
		void clear();
		
	protected:
		
		// Variables
		static Glib::ustring str_current_folder;
		Pdfchain::FileFilterType default_filter;
		class_dialogs *pt_dialogs;
		
		// Widgets
		Gtk::FileChooserDialog
			*pt_filechooser;
		
		Gtk::FileFilter
			*pt_filefilter1,
		*pt_filefilter2,
		*pt_filefilter3;
		
		Gtk::CheckButton
			*pt_checkbutton_add_extension;
		
		//Methodes
		void create_filechooser(Gtk::Window*, Pdfchain::FileChooserType, Pdfchain::FileFilterType, Pdfchain::FileFilterType);
		Gtk::FileFilter* create_filefilter(Pdfchain::FileFilterType);
		Glib::ustring add_extension(Glib::ustring); // Add File Extension (if not given)
};

#endif
