#include "papaya/Plugin.h"

#include <list>
#include <algorithm>

struct mudlogData {
  Connection * connection;
  FILE * fp;
};


class G_MODULE_EXPORT MudLog : public Plugin {

 public:

  MudLog();
  ~MudLog();

  void onEvent(Event *, Connection *);
  void input(Connection *, char *);
  void output(Connection *, char *);


 private:

  struct mudlogData * find_data(Connection *);
  void add_data(struct mudlogData *);
  void remove_data(struct mudlogData *);

  void write(Connection *, char *, bool);

  struct mudlogData * createLogFile(Connection *);
  void closeLogFile(struct mudlogData *);

  typedef std::list<struct mudlogData *> MudlogDataList;
  std::list<struct mudlogData *> mudlogList;

};
