#ifndef INCLUDE_ROOM_H
#define INCLUDE_ROOM_H

#include <regex.h>

#include "Mapper.h"
#include "Exit.h"

class Room {
 public:

  // Default constructor.  Will generate a unique ID.
  Room(int id);

  // Used when loading a room from a save file.
  Room(int id, int vnum, char * name, char * description);

  // Destructor.
  ~Room();

  void setID(int);
  void setVnum(int);
  void setName(char *);
  void setDescription(char *);

  int getID();
  int getVnum();
  char * getName();
  char * getDescription();

  void printRoom();
  void exportRoom(FILE *);

  int getX();
  int getY();
  int getZ();

  void setLocation(int, int, int);

  // Parses the output from the MUD into a room description.
  void parseOutput(char *, char *);

  // The exits leading from this room.
  Exit * exits[MAX_EXITS];

 private:
  
  // Each room has a unique internal ID.
  int id;

  // Some rooms may have a vnum attached to them.
  int vnum;

  // The room's name.
  char * name;

  // The room's description.
  char * description;

  // The x, y and z co-ordinates of this room.
  int x, y, z;

  // Retrieves the matching text into the output buffer.
  void getString(regmatch_t *, char *, int, char *);

  // Replaces instances of a character with a string.
  void replaceString(char *, char, char *);

};

#endif
