#include <stdlib.h>

#include <errno.h>
#include <sys/types.h>
#include <string.h>
#include <stdio.h>
#include <regex.h>

#ifndef WIN32
#include <unistd.h>
#include <sys/wait.h>
#else
#include <process.h>
#endif

#ifdef MIDI
#include <libkmid/libkmid.h>
#endif

#include "Win32PluginAPI.cpp"
#include "MSP.h"

extern char ** environ;

static MSP * msp;

#define MAJOR "1"
#define MINOR "2"

extern "C" char * plugin_query_name() {
  return "MSP";
}

extern "C" char * plugin_query_description() {
  return _("A basic implementation of the MUD sound protocol.");
}

extern "C" char * plugin_query_major() {
  return MAJOR;
}

extern "C" char * plugin_query_minor() {
  return MINOR;
}

extern "C" void plugin_init(void) {
  msp = new MSP();
}

extern "C" void plugin_cleanup(void) {
  delete msp;
}

int exec_external(char * prog, char * args[], int nargs) {

#ifdef WIN32
  // @@ Find the windows exec_external stuff (gmudftp suggested source)
  return -1;
#else
  int pid, i;
  char * myargs[128]; // Up to 128 arguments of 128 characters.
  
  if (!prog || prog[0] == '\0')
    return 1;
  
  pid = fork();
  if (pid == -1)
    return -1;
  
  // Now exec the child
  if (pid == 0) {
    
    myargs[0] = strdup(prog);
    for (i = 0; i < nargs; i++)
      myargs[i+1] = strdup(args[i]);
    
    myargs[i+1] = NULL;
    execve(prog, myargs, environ);
    perror("execve");
    exit(127);
  }

  return 1;
#endif
}

int MSP_Callback(regex_t * regexp, Connection * c, char * buf, char * stripped_buf, void * d) {
#ifdef WIN32
        return 0;
#else

  char file[256];
  regmatch_t match[2];
  char * args[128];

  regexec(regexp, buf, 2, match, 0);
  memcpy(file, buf + match[1].rm_so, match[1].rm_eo - match[1].rm_so);
  file[match[1].rm_eo - match[1].rm_so] = '\0';

  args[0] = strdup(file);
  args[1] = NULL;

  if (!strcmp((char *)d, MSP_MIDI)) {

#ifdef MIDI

    // @@ Only do this if required to by the song...
    kMidStop();
    if (!strcmp(file, "off"))
      return 0;

    kMidLoad(file);
    kMidPlay();
#endif
    return 0;
  } else if (!strcmp((char *)d, MSP_WAV)) {

    exec_external("/usr/bin/play", (char **)args, 1);
    return 0;
  }

  return 1;
#endif
}

MSP::MSP() {

  version = 0.1;
  name = strdup("MUD Sound Protocol");
  
#ifdef MIDI
  kMidInit();
#endif

  sound = system_trigger_entity_new("!!SOUND\\(([^ ]+).*\\)", NULL, MSP_Callback, NULL);
  midi = system_trigger_entity_new("!!MUSIC\\(([^ ]+).*\\)", NULL, MSP_Callback, NULL);

  entity_handler_add_entity(get_entity_handler(), "MUD Sound Protocol", (Entity *)sound);
  entity_handler_add_entity(get_entity_handler(), "MUD Sound Protocol", (Entity *)midi );

  register_plugin(this, VERSION);
}

MSP::~MSP() {
  printf("FIXME: delete the sound and midi triggers.\n");

  unregister_plugin(this);
}

char * MSP::getDescription() {
  return "MUD sound protocol support";
}
