#include <sys/types.h>

#include <stdlib.h>
#include <string.h>
#include <sys/timeb.h>
#include <stdio.h>
#include <time.h>

#include "Clock.h"
#include "Win32PluginAPI.cpp"

#define MAJOR "1"
#define MINOR "1"

struct indicator * first_clock = (struct indicator *)NULL;
static Clock * cl = (Clock *)NULL;

extern "C" G_MODULE_EXPORT void plugin_init(plugin_address_table_t * pat) {
  plugin_address_table_init(pat);
  cl = new Clock();
}

extern "C" G_MODULE_EXPORT void plugin_cleanup(void) {
  delete cl;
  cl = (Clock *)NULL;
}

extern "C" G_MODULE_EXPORT char * plugin_query_name() {
  return "Clock";
}

extern "C" G_MODULE_EXPORT char * plugin_query_description() {
  return _("Adds a clock to the plugin tray.");
}

extern "C" G_MODULE_EXPORT char * plugin_query_major() {
  return MAJOR;
}

extern "C" G_MODULE_EXPORT char * plugin_query_minor() {
  return MINOR;
}

Clock::Clock() {

  version = 1.0;
  name = strdup("Clock");
  first_clock = NULL;

  register_plugin(this, VERSION);
}

Clock::~Clock() {
  free(name);
  name = NULL;

  struct indicator * ind;
  struct indicator * ind_next;

  for (ind = first_clock; ind; ind = ind_next) {
    ind_next = ind->next;
    
	vt_remove_from_tray(connection_get_vt(ind->connection), ind->event_box, ind->frame);
    gtk_timeout_remove(ind->timeout);
    free(ind);
  }

  unregister_plugin(this);
}

struct indicator * Clock::findIndicator(Connection * c, bool fnew) {

  struct indicator * tmp = first_clock;

  for ( ;tmp; tmp = tmp->next) {
    if (tmp->connection == c)
      return tmp;
  }

  if (!fnew)
    return (struct indicator *)NULL;

  return newIndicator(c);
}

int clock_timeout(gpointer data) {
  struct indicator * ind = (struct indicator *)data;
  char buf[1024];
  time_t curr;

  time(&curr);

  sprintf(buf, "%s", ctime(&curr));
  *(strchr(buf, '\n')) = '\0';

  gtk_label_set_text(GTK_LABEL(ind->widget), buf);

  return 1;
}

struct indicator * Clock::newIndicator(Connection * c) {
  struct indicator * tmp = (struct indicator *)malloc(sizeof(struct indicator));

  tmp->connection = c;
  tmp->widget = gtk_label_new(_("Initialising clock"));

  gtk_widget_show(tmp->widget);

  tmp->event_box = gtk_event_box_new();
  tmp->tooltips = gtk_tooltips_new();
  gtk_tooltips_set_tip(tmp->tooltips, tmp->event_box, "Clock: shows the current time.", NULL);

  gtk_container_add(GTK_CONTAINER(tmp->event_box), tmp->widget);

  // Insert into list
  tmp->next = first_clock;
  first_clock = tmp;

  // Add into the tray.
  vt_add_to_tray(connection_get_vt(c), tmp->event_box, &tmp->frame);

  // Configure a timeout event.
  tmp->timeout = gtk_timeout_add(1000, clock_timeout, (gpointer)tmp);
  return tmp;
}

void Clock::remove(struct indicator * ind) {
  struct indicator * tmp = first_clock;

  gtk_timeout_remove(ind->timeout);

  if (ind == first_clock) {
    first_clock = ind->next;
    free(ind);
    return;
  }

  for (; tmp; tmp = tmp->next) {
    if (ind == tmp->next) {
      tmp->next = ind->next;
      free(ind);
      return;
    }
  }
}

void Clock::onEvent(Event * e, Connection * c) {

  if (event_get_type(e) == EvConnect) {
    // This will create a new indicator if necessary
    findIndicator(c, TRUE);
    return;
  }

  if (event_get_type(e) == EvDisconnect) {
    struct indicator * ind = findIndicator(c, FALSE);
    if (ind) {
      vt_remove_from_tray(connection_get_vt(c), ind->event_box, ind->frame);
      g_free(ind->tooltips);

      // Remove from the linked list.
      remove(ind);
    }
    return;
  }
}

char * Clock::getDescription() {
  return "Displays the current date and time.";
}
