#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "mudclient.h"

#include "PluginData.h"
#include "PluginHandler.h"

extern PluginHandler * phandler;

/**
 * PluginData is a basic storage class.  Containing info such as the plugin
 * filename and version.
 */

PluginData::PluginData(char * fname) {

  en = FALSE;
  seen = FALSE; // We have seen this plugin in the config file.
  author = strdup("");
  authorEmail = strdup("");

  downloadURL = strdup("");
  checksum = strdup("");

  major = 0;
  minor = 0;

  version = strdup("");
  description = strdup("");
  dialog = NULL;
  filename = NULL;

  char * pc = strchr(fname, '.');
  if (pc)
    *pc = '\0';

  char * start = fname;
  
  while (1) {
    pc = strchr(start, '/');
    if (!pc) {
      name = strdup(start);
      break;
    }

    start = pc + 1;
  }

}

PluginData::~PluginData() {

  free(author);
  free(authorEmail);
  free(downloadURL);
  free(checksum);
  free(version);
  free(description);
  free(name);
  free(filename);
}

void PluginData::toString() {

  printf(_("Author: %s\n"
	 "Email: %s\n"
	 "Download: %s\n"
	 "Version: %s\n"
	 "Name: %s\n"
	 "Description: %s\n"),
	 author, authorEmail, downloadURL, version, name, description);
}

void PluginData::enable(bool b) {

  if (en && !b) {
    phandler->unloadFile(this);
    en = b;
    return;
  }

  en = b;

  if (en) {
    phandler->loadFile(this);
  }
}

bool PluginData::enabled() {
  return en;
}

void PluginData::setDescription(char * s) {
  if (description)
    free(description);
  description = strdup(s);
}

void PluginData::setName(char * s) {
  if (name)
    free(name);

  name = strdup(s);
}

void PluginData::setFilename(char * s) {
  if (filename)
    free(filename);

  filename = strdup(s);
}

void PluginData::setMajor(char * s) {
  major = atoi(s);
}

void PluginData::setMinor(char * s) {
  minor = atoi(s);
}

char * PluginData::getDescription() {
  return description;
}

char * PluginData::getName() {
  return name;
}

char * PluginData::getFilename() {
  return filename;
}

int PluginData::getMajor() {
  return major;
}

int PluginData::getMinor() {
  return minor;
}
