#include "CompressionPreference.h"
#include "mudclient.h"

extern PreferenceHandler * preferenceHandler;

CompressionPreference::CompressionPreference() {
  xml = NULL;

  availablePreferences = g_list_append(availablePreferences, new PreferenceOptions("Compression", "compression_checkbutton", WidgetToggle));
  availablePreferences = g_list_append(availablePreferences, new PreferenceOptions("CompressionOffCommand", "compression_command_entry", WidgetEntry));

}

CompressionPreference::~CompressionPreference() {
  if (xml)
    g_object_unref(xml);
}

GtkWidget * CompressionPreference::getWidget() {
  char buf[1024];
  snprintf(buf, 1024, "%s/share/papaya/compressionpreferences.glade", getPrefix());
  
  if (xml) {
    GtkWidget * vbox = glade_xml_get_widget(xml, "vbox");
    return vbox;
  }

  xml = glade_xml_new(buf, "vbox", NULL);
  glade_xml_signal_autoconnect(xml);
  GtkWidget * vbox = glade_xml_get_widget(xml, "vbox");
  gtk_widget_show(vbox);
  return vbox;
}

void CompressionPreference::destroyWidget() {
  if (xml)
    g_object_unref(xml);
  xml = NULL;
}

Category * CompressionPreference::getCategories() {
  return (Category *)compression_categories;
}

