#ifndef INCLUDE_PAPAYAVT_H
#define INCLUDE_PAPAYAVT_H

#include "VT.h"
#include "ColouredLabel.h"
#include "SystemColour.h"

int papaya_input_entry_activate(GtkEditable *, gpointer);
int papaya_keypress(GtkWidget *, GdkEventKey *);

Connection * getCurrentConnection();

class GTKTwoVT : public VT {
  
 public:

  GTKTwoVT(Connection *);
  ~GTKTwoVT();

  void append(char *);
  void scroll(); // public since we might want to ask to scroll only when
                 // no more data arriving.

  void addToTray(GtkWidget *, GtkWidget **);
  void removeFromTray(GtkWidget *, GtkWidget *);

  void prefsUpdated(); // The prefs have been updated.  Fix fonts etc.
  void setInput(char *);
  void setMode(VTMode);

  void focus();

  void hideCommands();
  void showCommands();
  bool showingCommands();

  // Fill these in
  GtkWidget * getOutput();
  GtkWidget * getBox();
  GtkWidget * getPrompt();
  GtkWidget * getInput();

  GtkWidget * leftprompt;
  GtkWidget * rightprompt;

  void hideInput();
  void showInput();

  void keypressEvent(GtkWidget *, GdkEventKey *);

  int width();
  int height();

  void initialise();
  struct colour_table * getColourTable();

  void setTitleBar(char *);
  void setIcon(char *);


 private:
  void initTextArea();
  void createTagTable();
  void setDefaults();
  void setTerminalSettings(Prefs *);

  //  char * parseVTCode(char *);
  char * zapChars(char *);
  //  void setColour(char *);
  //  void setPapayaColour(char *);
  //  void resetPapayaColour();
  //  void setActualColour(char *);
  //  void deleteOneChar();
  //  void printVT(char *);
  void insertText(char *);
  //  void beep(char *);
  //  bool doScroll(); // Do we need to scrolll the VT?
  //  char * parsePlainVTCode(char *);
  //  char * parseBracketVTCode(char *);
  //  char * parseXTermCode(char *);
  
  void snarfPrompt(char *);
  char * getColourCodes(char *);

  void setPrompt(char *);
  void getScreenSize(int *, int *);

  void setPosition(char *);
  void setPosition(int, int);

  //  char * findStartOfLine(char *, char *);
  //  void moveLeft();
  //  void moveRight();

  //  void createFilteredWidget();
  //  void destroyFilteredWidget();
  
  GtkWidget * input_vbox;

  //  GtkWidget * tray;

  // vbox for putting output widgets in as the filtered output might be added
  // at any time during the connection and not just at the start.
  GtkWidget * output_vbox;

  // General output widgets
  GtkWidget * scrolled_window;
  //  GtkWidget * text_view;
  GtkWidget * terminal;
  //  GtkTextBuffer * buffer;

  // Filtered text widgets
  //  GtkWidget * filtered_scrolled_window;
  //  GtkWidget * filtered_text_view;
  //  GtkTextBuffer * filtered_buffer;

  GtkWidget * input;
  GtkWidget * hbox;
  GtkWidget * vbox;

  GtkWidget * prompthbox;
  //  GtkWidget * prompt;
  ColouredLabel * prompt;

  //  GdkFont * fixed_font;

  //  GtkTextMark * marker, * filtered_marker;

  SystemColour * systemColour;

  //  int fg, bg;

  //  bool bold, faint, italicised, concealed, flashing, rapid_flashing;
  //  bool singly_underlined, negative_image, crossed_out;

  //  bool background_color_default, foreground_color_default;
  //  bool papaya_colour; // So we don't use foreground_color_default when we shouldn't.
  //  int papaya_colour_red, papaya_colour_green, papaya_colour_blue;

  //  bool flashing_text; // Nasty hack for flashing filter support.
  //  bool should_scroll; // Nasty hack for scroll when at bottom.

  bool appended_to_filtered, appended_to_output;
  bool colour_enabled; // Cache of the ColourEnabled preference.
  bool prompt_on_input_line; // Cache of prompt on input line preference.
  char * character_set; // cache of charset preference.

  //  int filtered_lines;
  int output_lines;


  GList * tags;
  GList * custom_tag_list;
};

#endif // INCLUDE_PAPAYAVT_H
