
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: utils_mrl.h 2352 2007-06-27 15:49:22Z mschwerin $
 *
 */

#include "types.h"

#ifndef HAVE_UTILS_MRL_H
#define HAVE_UTILS_MRL_H

/**
 * Returns the filename contained in the passed MRL. The returned string
 * must be freed.
 */
char *mrl_get_filename (const char *mrl);


/**
 * Returns TRUE if the filename of the passed MRL is a regular file. Regular
 * files in this context are files and directories on a local or a remote
 * filesystem (including ftp, http) that are not device files.
 */
bool mrl_filename_is_regular (const char *mrl);


// Returns TRUE if the filename of the passed MRL is a device file.
bool mrl_filename_is_device (const char *mrl);


#endif /* HAVE_UTILS_MRL_H */
