###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_thegreenbow_ipsec_vpn_client_bof_vuln.nasl 7007 2010-01-27 11:52:24Z jan $
#
# TheGreenBow IPSec VPN Client Local Stack Overflow Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(902104);
  script_version("$Revision: 8288 $: 1.0");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2010-0392");
  script_name("TheGreenBow IPSec VPN Client Local Stack Overflow Vulnerability");
  desc = "
  Overview:
  This host has TheGreenBow IPSec VPN Client installed and is prone to Stack
  Overflow vulnerability.

  Vulnerability Insight:
  The flaw is caused due to a boundary error when processing certain sections of
  'tgb' (policy) files. Passing an overly long string to 'OpenScriptAfterUp' will
  trigger the overflow.

  Impact:
  Successful exploitation allows the attacker to execute arbitrary code on
  the system or compromise a system.

  Impact Level:System/Application

  Affected Software/OS:
  TheGreenBow IPSec VPN Client version 4.65.003 and prior.

  Fix: Apply patch from below link,
  http://www.thegreenbow.com/download.php?id=1000150

  *****
  NOTE: Ignore this warning, if above mentioned patch is manually applied.
  *****

  References:
  http://secunia.com/advisories/38262
  http://xforce.iss.net/xforce/xfdb/55793
  http://www.senseofsecurity.com.au/advisories/SOS-10-001

  CVSS Score:
    CVSS Base Score      : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score  : 7.1
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of TheGreenBow IPSec VPN Client");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_thegreenbow_ipsec_vpn_client_detect.nasl");
  script_require_keys("TheGreenBow-IPSec-VPN-Client/Ver");
  exit(0);
}


include("version_func.inc");

vpnPort = 500;
if(!get_udp_port_state(vpnPort)){
  exit(0);
}

vpnVer = get_kb_item("TheGreenBow-IPSec-VPN-Client/Ver");
if(!vpnVer){
  exit(0);
}

# Check for TheGreenBow IPSec VPN Client version <= 4.65.003 (4.6.5.3)
if(version_is_less_equal(version:vpnVer, test_version:"4.6.5.3")){
  security_hole(port:vpnPort, proto:"udp");
}
