###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms09-067.nasl 5697 2009-11-11 11:32:09Z nov $
#
# Microsoft Office Excel Multiple Vulnerabilities (972652)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900887);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-3127", "CVE-2009-3128", "CVE-2009-3129", "CVE-2009-3130",
                "CVE-2009-3131", "CVE-2009-3132", "CVE-2009-3133", "CVE-2009-3134");
  script_bugtraq_id(36943, 36944, 36945, 36946, 36908, 36909, 36911, 36912);
  script_name("Microsoft Office Excel Multiple Vulnerabilities (972652)");
  desc = "
  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-067.

  Vulnerability Insight:
  - An error in the parsing of Excel spreadsheets can be exploited to corrupt
    memory via a specially crafted Excel file.
  - An error in the processing of certain record objects can be
    exploited to corrupt memory via a specially crafted Excel file.
  - Another error in the processing of certain record objects can be
    exploited to corrupt memory via a specially crafted Excel file.
  - An error in the processing of Binary File Format (BIFF) records
    can be exploited to cause a heap-based buffer overflow via a specially
    crafted Excel file.
  - An error in the handling of formulas embedded inside a cell can
    be exploited to corrupt memory via a specially crafted Excel file.
  - An error when loading Excel formulas can be exploited to corrupt
    a pointer when a specially crafted Excel file is being opened.
  - An error when loading Excel records can be exploited to corrupt
    memory via a specially crafted Excel file.
  - An error when processing Excel record objects can be exploited
    via a specially crafted Excel file.

  Impact:
  Successful exploitation could execute arbitrary code on the remote system
  and corrupt memory, buffer overflow via a specially crafted Excel file.

  Impact Level: System/Application

  Affected Software/OS:
  Microsoft Excel Viewer 2003/2007
  Microsoft Office Excel 2002/2003/2007
  Microsoft Office Compatibility Pack for Word,Excel,PowerPoint 2007 File Formats SP 1/2

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/bulletin/ms09-067.mspx

  References:
  http://secunia.com/advisories/37299/
  http://support.microsoft.com/kb/972652
  http://www.microsoft.com/technet/security/bulletin/ms09-067.mspx

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Office Excel and Excel Viewer");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_office_products_version_900032.nasl",
                      "secpod_ms_office_detection_900025.nasl");
  script_require_keys("SMB/Office/Excel/Version");
  script_require_ports(139, 445);
  exit(0);
}


include("secpod_reg.inc");
include("version_func.inc");

if(hotfix_check_sp(win2k:5, xp:4, win2003:3) <= 0){
  exit(0);
}

# Check for Office Excel 2002/2003/2007
excelVer = get_kb_item("SMB/Office/Excel/Version");
if(excelVer =~ "^(10|11|12)\..*")
{
  # Check for Office Excel 10.0 < 10.0.6856.0 or 11.0 < 11.0.8316.0 or 12.0 < 12.0.6514.5000
  if(version_in_range(version:excelVer, test_version:"10.0", test_version2:"10.0.6855.9")||
     version_in_range(version:excelVer, test_version:"11.0", test_version2:"11.0.8315.9")||
     version_in_range(version:excelVer, test_version:"12.0", test_version2:"12.0.6514.4999"))
  {
    security_hole(0);
    exit(0);
  }
}

# Check for Office Compatiability Pack 2007
if(get_kb_item("SMB/Office/ComptPack/Version") =~ "^12\..*")
{
  xlcnvVer = get_kb_item("SMB/Office/XLCnv/Version");
  if(xlcnvVer)
  {
    # Check for Office Excel Converter 2007 version 12.0 < 12.0.6514.5000
    if(version_in_range(version:xlcnvVer, test_version:"12.0", test_version2:"12.0.6514.4999"))
    {
      security_hole(0);
      exit(0);
    }
  }
}

# For Microsoft Office Excel Viewer 2003/2007
xlviewVer = get_kb_item("SMB/Office/XLView/Version");
if(xlviewVer =~ "^(11|12)\..*")
{
  # Check for Excel Viewer 11.0 < 11.0.8313.0 (2003) or 12.0 < 12.0.6514.5000 (2007)
  if(version_in_range(version:xlviewVer, test_version:"11.0", test_version2:"11.0.8312.9") ||
    version_in_range(version:xlviewVer, test_version:"12.0", test_version2:"12.0.6514.4999")){
    security_hole(0);
  }
}
