###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_dovecot_sieve_mult_bof_vuln.nasl 4844 2009-19-22 11:17:55Z sep $
#
# Dovecot Sieve Plugin Multiple Buffer Overflow Vulnerabilities
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2008 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(901026);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-3235");
  script_bugtraq_id(36377);
  script_name("Dovecot Sieve Plugin Multiple Buffer Overflow Vulnerabilities");
  desc = "
  Overview: This host has Dovecot Sieve Plugin installed and is prone to
  multiple Buffer Overflow Vulnerabilities

  Vulnerability Insight:
  Multiple buffer overflow errors in the CMU libsieve when processing
  malicious SIEVE scripts.

  Impact:
  Successful attack could allow malicious people to crash an affected
  application or execute arbitrary code.

  Impact Level: Application

  Affected Software/OS:
  Dovecot versions 1.0 before 1.0.4 and 1.1 before 1.1.7

  Fix: Apply the patch  or upgrade to Dovecot version 1.1.4 or 1.1.7
  http://www.dovecot.org/download.html
  http://hg.dovecot.org/dovecot-sieve-1.1/rev/049f22520628
  http://hg.dovecot.org/dovecot-sieve-1.1/rev/4577c4e1130d

  *****
  NOTE: Ignore this warning, if above mentioned patch is already applied.
  *****

  References:
  http://xforce.iss.net/xforce/xfdb/53248
  http://www.vupen.com/english/advisories/2009/2641
  http://www.dovecot.org/list/dovecot-news/2009-September/000135.html

  CVSS Score:
  CVSS Base Score        : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score  : 5.5
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Dovecot");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_dovecot_detect.nasl");
  script_require_keys("Dovecot/Ver");
  exit(0);
}


include("version_func.inc");

dovecotVer = get_kb_item("Dovecot/Ver");
if(dovecotVer != NULL)
{
  if(version_in_range(version:dovecotVer, test_version:"1.0", test_version2:"1.0.3") ||
    version_in_range(version:dovecotVer, test_version:"1.1", test_version2:"1.1.6"))
  {
    security_hole(0);
    exit(0);
  }
}
