###############################################################################
# OpenVAS Vulnerability Test
# $Id: novell_imanager_detect.nasl 7516 2010-05-04 08:24:56Z chandra $
#
# Novell iManager Detection
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

# need desc here to modify it later in script.
desc = "Overview:
This host is running Novell iManager, a Web-based administration
console that provides customized access to network administration
utilities and content from virtually any location.

See also:
http://www.novell.com/products/consoles/imanager/overview.html

Risk factor : None";

if (description)
{
 script_id(100434);
 script_version ("1.0-$Revision: 7516 $");
 script_tag(name:"risk_factor", value:"None");
 script_name("Novell iManager Detection");
 script_description(desc);
 script_summary("Checks for the presence of Novell iManager");
 script_category(ACT_GATHER_INFO);
 script_family("Service detection");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 8080, 8443);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");

port = get_http_port(default:8080);

if(!get_port_state(port))exit(0);

 url = string("/nps/servlet/webacc?taskId=dev.Empty&merge=fw.About");
 req = http_get(item:url, port:port);
 buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
 if( buf == NULL )exit(0);

 if("iManager" >< buf)
 {

    url = string("/nps/version.jsp"); # http://www.novell.com/coolsolutions/tip/18634.html
    req = http_get(item:url, port:port);
    buf = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);

    vers = string("unknown");
    ### try to get version 
    version = eregmatch(string: buf, pattern: "([0-9.]+)",icase:TRUE);

    if ( !isnull(version[1]) ) {
       vers=chomp(version[1]);
       set_kb_item(name:string("cpe:/a:novell:imanager:",vers), value: TRUE);
    } else {
       set_kb_item(name:string("cpe:/a:novell:imanager"), value: TRUE);
    }  

    set_kb_item(name: string("www/", port, "/imanager"), value: string(vers));

    info = string("None\n\nNovell iManager Version '");
    info += string(vers);
    info += string("' was detected on the remote host.\n");

    desc = ereg_replace(
        string:desc,
        pattern:"None$",
        replace:info
    );

       if(report_verbosity > 0) {
         security_note(port:port,data:desc);
       }
       exit(0);

 }
exit(0);

