##############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_arcavir_av_prdts_detect.nasl 2570 2009-06-01 20:10:24Z june $
#
# ArcaVir AntiVirus Products Version Detection
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http//intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800719);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("ArcaVir AntiVirus Products Version Detection");
  desc = "
  Overview : This script finds the installed ArcaVir AntiVirus Products and
  saves the version in KB.

  Risk factor : None";

  script_description(desc);
  script_summary("Set Version of ArcaVir AntiVirus Products in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\ArcaBit")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (registry_enum_keys(key:key))
{
  avName = registry_get_sz(key:key + item, item:"DisplayName");
  if("ArcaVir" >< avName)
  {
    arcaVer = registry_get_sz(key:key + item, item:"DisplayVersion");
    if(arcaVer != NULL)
    {
      set_kb_item(name:"ArcaVir/AntiVirus/Ver", value:arcaVer);
      security_note(data:"Arca Bit Anti Virus version " + arcaVer +
                         " was detected on the host");
    }
    exit(0);
  }
}
