/* $Id: readonly.c,v 1.1 2006-04-25 15:36:09 bh Exp $
 *
 * Copyright (C) 2006 by Greenbone Networks GmbH
 * Author(s):
 * Bernhard Herzog <bh@intevation.de> (2006)
 *
 * This program is free software under the GNU GPL (>=v2)
 * Read the file COPYING coming with the software for details.
 */

/**
 * @file
 * Implement a mechanism to make a container widget "readonly".  This is
 * different from the container being insensitive in that some of it's
 * children may remain sensitive.
 * In the OpenVAS Client this is used to let the user browse e.g. the plugin
 * information of a report where the users need to interact with a tree view
 * but should no be able to change the information shown.
 */

#include <gtk/gtk.h>
#include "readonly.h"

static void
set_read_only_recursively (GtkWidget *widget, gpointer data)
{
  if (g_object_get_data(G_OBJECT(widget), "read-only-active"))
  {
    gtk_widget_set_sensitive(widget, TRUE);
  }
  else if (GTK_IS_CONTAINER(widget)
      && g_object_get_data(G_OBJECT(widget), "read-only-recurse"))
  {
    gtk_container_foreach(GTK_CONTAINER(widget), set_read_only_recursively,
	data);
  }
  else
  {
    gtk_widget_set_sensitive(widget, !GPOINTER_TO_INT(data));
  }
}

void
read_only_set_read_only (GtkWidget *widget, gboolean readonly)
{
  set_read_only_recursively (widget, GINT_TO_POINTER(readonly));
}

void
read_only_set_recurse (GtkWidget *widget)
{
  g_object_set_data(G_OBJECT(widget), "read-only-recurse",
      GINT_TO_POINTER(TRUE));
}

void
read_only_set_active (GtkWidget*widget)
{
  g_object_set_data(G_OBJECT(widget), "read-only-active",
      GINT_TO_POINTER(TRUE));
}
