#!/bin/sh

# Transform tests files for win32 platform or restore them for unix like.

# This script can be called twice with the same arg without making troubles to the files.
# This script is not reentrant !
# Every .xml .at files in the checktest source directory are modified ! 

usage()
{
  echo "usage: ./adapt_check_tests.sh win32|unix"
  exit 1
}

if [ "$#" -eq "1" ]; then 
  if [ "$0" != "./adapt_check_tests.sh" ]; then
    echo "This script must be called from where it resides."
    usage
  fi
  TARGET_PLATEFORM="$1" 
else
  usage 
fi 

CHECK_TEST_PATH="../lib/test"
PYTHON_CHECK_TEST_PATH="../python/test"

echo "Modifiying checktest files for $TARGET_PLATEFORM in directories $CHECK_TEST_PATH, $PYTHON_CHECK_TEST_PATH."

REMOVE_CARRIAGE_RETURN=' | tr -d "\\015"'
LINUX_PROG_CHECK="\(AT_CHECK[([ ]*\)\(t_[a-zA-Z1-9_]*\)\([] ]*,[ ]*\)"
WIN32_PROG_CHECK="\(AT_CHECK[([ ]*\)\(t_[a-zA-Z1-9_]*\)\(\.exe${REMOVE_CARRIAGE_RETURN}\)\([] ,]*\)"
WIN32_SUFFIX='.exe'

LINUX_PYTHON_CHECK="\(AT_CHECK[([ ]*python\)\( .*t_[a-zA-Z1-9_]*\.py\)\([] ]*,[ ]*\)"

adapt_check_tests_for_win32()
{
  # add WIN32_SUFFIX
  sed -i -e "s/^[ ]*$LINUX_PROG_CHECK/\1\2${WIN32_SUFFIX}${REMOVE_CARRIAGE_RETURN}\3/" $CHECK_TEST_PATH/*.at

  # transform .so to -0.dll
  sed -i -e 's/[.]so\([<"]\)/-0.dll\1/g' $CHECK_TEST_PATH/*.xml

  # call batch external code instead of shell external code
  sed -i -e "s/\(poutre_files\)\.sh/\1.bat/" $CHECK_TEST_PATH/poutre_external.xml

  # python.exe interpreter 
  sed -i -e "s/env python$/env python.exe/" $PYTHON_CHECK_TEST_PATH/*.py
  
  # add WIN32_SUFFIX, remove \r
  sed -i -e "s/^[ ]*$LINUX_PYTHON_CHECK/\1$WIN32_SUFFIX\2$REMOVE_CARRIAGE_RETURN\3/" $PYTHON_CHECK_TEST_PATH/*.atpy
}

restore_check_tests()
{
  # delete WIN32_SUFFIX
  sed -i -e "s/^[ ]*$WIN32_PROG_CHECK/\1\2\4/" $CHECK_TEST_PATH/*.at

  # transform -0.dll to .so
  sed -i -e "s/-0.dll/.so/g" $CHECK_TEST_PATH/*.xml

  # call shell external code instead of batch external code
  sed -i -e "s/\(poutre_files\)\.bat/\1.sh/" $CHECK_TEST_PATH/poutre_external.xml

  # python interpreter 
  sed -i -e "s/env python.exe/env python/" $PYTHON_CHECK_TEST_PATH/*.py

  # remove \r, delete WIN32_SUFFIX
  sed -i -e "s/$REMOVE_CARRIAGE_RETURN//" $PYTHON_CHECK_TEST_PATH/*.atpy
  sed -i -e "s/\(AT_CHECK[([]*python\)$WIN32_SUFFIX/\1/" $PYTHON_CHECK_TEST_PATH/*.atpy
}

case $TARGET_PLATEFORM in
  win32)
    adapt_check_tests_for_win32
    ;;
  unix)
    restore_check_tests
    ;;
  *)
    usage
    ;;
esac

exit 0


