#! /usr/bin/env python

from openturns import *
# This import is mandatory for study reload to succeed
from PyNMF import FUNC

TESTPREAMBLE()

try :
  
  myFunc = NumericalMathFunction()
  
  st = Study()
  st.setStorageManager( XMLStorageManager( "PyNMF.xml" ) )
  
  st.load()
  st.fillObject( "F", myFunc )

  inPt = NumericalPoint(2, 2.)
  outPt = myFunc ( inPt )
  print repr(outPt)

  outPt = myFunc ( (10., 11.) )
  print repr(outPt)

  inSample = NumericalSample(10, 2)
  for i in range(10):
    inSample[i] = NumericalPoint( (i,i) )
  print repr(inSample)

  outSample = myFunc ( inSample )
  print repr(outSample)

  outSample = myFunc ( ((100.,100.), (101.,101.), (102.,102.)) )
  print repr(outSample)

except :
  import sys
  print "t_NumericalMathFunction_python_load.py", sys.exc_type, sys.exc_value
