// SWIG file func_module.i
// Author : $LastChangedBy: schueller $
// Date : $LastChangedDate: 2011-07-06 12:03:57 +0200 (Wed, 06 Jul 2011) $
// Id : $Id: func_module.i 1991 2011-07-06 10:03:57Z schueller $

%module(package="openturns", docstring="Function primitives.") func
%feature("autodoc","1");

%{
#include "OTconfig.hxx"
#include "OTCommon.hxx"
#include "OTType.hxx"
#include "OTStat.hxx"
#include "OTGraph.hxx"
#include "OTFunc.hxx"
%}

%include typemaps.i
%include OTtypes.i
%include OTexceptions.i
%include std_vector.i

/* Base/Common */
%import common_module.i

/* Wrapper */
%import wrapper_module.i
%import BaseWrapperTemplateDefs.i

/* Base/Type */
%import typ_module.i
%import BaseTypTemplateDefs.i

/* Base/Stat */
%import statistics_module.i
%import BaseStatisticsTemplateDefs.i

/* Base/Func */
%include SpecFunc.i
%include FunctionCache.i
%include NumericalMathEvaluationImplementation.i
%include NumericalMathGradientImplementation.i
%include NumericalMathHessianImplementation.i
%include NoNumericalMathEvaluationImplementation.i
%include NoNumericalMathGradientImplementation.i
%include NoNumericalMathHessianImplementation.i
%include LinearNumericalMathEvaluationImplementation.i
%include LinearNumericalMathGradientImplementation.i
%include QuadraticNumericalMathEvaluationImplementation.i
%include ConstantNumericalMathGradientImplementation.i
%include ConstantNumericalMathHessianImplementation.i
%include ComputedNumericalMathEvaluationImplementation.i
%include ComputedNumericalMathGradientImplementation.i
%include ComputedNumericalMathHessianImplementation.i
%include ComposedNumericalMathEvaluationImplementation.i
%include ComposedNumericalMathGradientImplementation.i
%include ComposedNumericalMathHessianImplementation.i
%include ProductNumericalMathEvaluationImplementation.i
%include ProductNumericalMathGradientImplementation.i
%include ProductNumericalMathHessianImplementation.i
%include NumericalMathFunctionImplementation.i
%include ProductNumericalMathFunction.i
%include NumericalMathFunction.i
%include ComposedNumericalMathFunction.i
%include DualLinearCombinationEvaluationImplementation.i
%include DualLinearCombinationGradientImplementation.i
%include DualLinearCombinationHessianImplementation.i
%include LinearCombinationEvaluationImplementation.i
%include LinearCombinationGradientImplementation.i
%include LinearCombinationHessianImplementation.i
%include LinearNumericalMathFunction.i
%include UniVariatePolynomialImplementation.i
%include UniVariatePolynomial.i
%include IndicatorNumericalMathEvaluationImplementation.i
%include ProductPolynomialEvaluationImplementation.i
%include Basis.i
%include BasisSequenceImplementation.i
%include BasisSequence.i
%include BasisSequenceFactoryImplementation.i
%include BasisSequenceFactory.i
%include LAR.i
%include LARLasso.i
%include LARFSZero.i

/* At last we include template definitions */
%include BaseFuncTemplateDefs.i
