//                                               -*- C++ -*-
/**
 * @file  PythonNumericalMathEvaluationImplementation.hxx
 * @brief This class binds a Python function to an Open TURNS' NumericalMathFunction
 *
 * (C) Copyright 2005-2011 EDF
 *
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 *
 *
 * \author $LastChangedBy: schueller $
 * \date   $LastChangedDate: 2011-08-01 13:42:13 +0200 (Mon, 01 Aug 2011) $
 */

#ifndef OPENTURNS_PYTHONNUMERICALMATHFUNCTIONIMPLEMENTATION_HXX
#define OPENTURNS_PYTHONNUMERICALMATHFUNCTIONIMPLEMENTATION_HXX

#include "Python.h"
#include "NumericalMathEvaluationImplementation.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Func {


      /**
       * @class PythonNumericalMathEvaluationImplementation
       *
       * This class binds a Python function to an Open TURNS' NumericalMathFunction
       */
      class PythonNumericalMathEvaluationImplementation
        : public NumericalMathEvaluationImplementation
      {
        CLASSNAME;
      public:

        typedef NumericalMathEvaluationImplementation::Description              Description;
        typedef NumericalMathEvaluationImplementation::NumericalPoint           NumericalPoint;
        typedef NumericalMathEvaluationImplementation::Matrix                   Matrix;
        typedef NumericalMathEvaluationImplementation::InvalidArgumentException InvalidArgumentException;
        typedef NumericalMathEvaluationImplementation::InternalException        InternalException;
        typedef NumericalMathEvaluationImplementation::NumericalSample          NumericalSample;
        typedef NumericalMathEvaluationImplementation::StorageManager           StorageManager;

        /** Constructor from Python object*/
        PythonNumericalMathEvaluationImplementation(PyObject * pyCallable);

        /** Copy constructor */
        PythonNumericalMathEvaluationImplementation(const PythonNumericalMathEvaluationImplementation & other);

        /** Virtual constructor */
        virtual PythonNumericalMathEvaluationImplementation * clone() const;

        /** Destructor */
        virtual ~PythonNumericalMathEvaluationImplementation();

        /** Comparison operator */
        Bool operator ==(const PythonNumericalMathEvaluationImplementation & other) const;

        /** String converter */
        virtual String __repr__() const;
        virtual String __str__(const String & offset) const;


        /** Test for actual implementation */
        virtual Bool isActualImplementation() const;


        /* Here is the interface that all derived class must implement */

        /** Operator () */
        virtual NumericalPoint operator() (const NumericalPoint & inP) const;
        /* throw(InvalidArgumentException,InternalException); */

        virtual NumericalSample operator() (const NumericalSample & inS) const;
        /* throw(InvalidArgumentException,InternalException); */

        /** Accessor for input point dimension */
        virtual UnsignedLong getInputDimension() const;
        /*        throw(InternalException);*/

        /** Accessor for output point dimension */
        virtual UnsignedLong getOutputDimension() const;
        /*        throw(InternalException);*/

        /** Method save() stores the object through the StorageManager */
        virtual void save(StorageManager::Advocate & adv) const;

        /** Method save() reloads the object from the StorageManager */
        virtual void load(StorageManager::Advocate & adv);

      protected:


      private:

        friend class Base::Common::Factory<PythonNumericalMathEvaluationImplementation>;

        /** Default constructor */
        PythonNumericalMathEvaluationImplementation();

        /** Handle python exceptions */
        void handleException() const;
        
        /** The underlying Python callable object */
        PyObject * pyObj_;

      }; /* class PythonNumericalMathEvaluationImplementation */


    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_PYTHONNUMERICALMATHFUNCTIONIMPLEMENTATION_HXX */
