// SWIG file NumericalMathFunction.i
// Author : $LastChangedBy: schueller $
// Date : $LastChangedDate: 2011-08-01 13:42:13 +0200 (Mon, 01 Aug 2011) $
// Id : $Id: NumericalMathFunction.i 2060 2011-08-01 11:42:13Z schueller $

%{
#include "NumericalMathFunction.hxx"
#include "PythonNumericalMathEvaluationImplementation.hxx"

namespace OpenTURNS { 

  template <>
  struct traitsPythonType<OpenTURNS::Base::Func::NumericalMathFunction>
  {
    typedef _PyObject_ Type;
  };

  template <>
  inline
  OpenTURNS::Base::Func::NumericalMathFunction
  convert<_PyObject_,OpenTURNS::Base::Func::NumericalMathFunction>(PyObject * pyObj)
  {
   if (!PyCallable_Check( pyObj )) {
     throw OT::Base::Common::InvalidArgumentException(HERE) << "Argument is not a callable object (function or class)";
   }

   return OpenTURNS::Base::Func::NumericalMathFunction(new OpenTURNS::Base::Func::NumericalMathFunctionImplementation(new OpenTURNS::Base::Func::PythonNumericalMathEvaluationImplementation(pyObj) ) );

  }

} /* namespace OpenTURNS */

%}

%pythoncode %{

class OpenTURNSPythonFunction :

  def __init__(self, n=0, p=0) :
    # Warning: these names are used in PythonNumericalMathEvaluationImplementation class. Synchronize the files if changed
    self.descIn  = []
    self.descOut = []
    self.n = n
    self.p = p
    pass

  def setInputDescription(self, descIn):
    if (len(descIn) != self.n):
      raise ValueError, "Input description size does NOT match input dimension"
    self.descIn  = descIn
    pass

  def setOutputDescription(self, descOut):
    if (len(descOut) != self.p):
      raise ValueError, "Output description size does NOT match output dimension"
    self.descOut  = descOut
    pass

  def getInputDimension(self) :
    return self.n

  def getOutputDimension(self) :
    return self.p

  def __str__(self):
    return "OpenTURNSPythonFunction( %s #%d ) -> %s #%d" % (self.descIn, self.n, self.descOut, self.p)

  def __repr__(self):
    return self.__str__()

  def __call__(self, X) :
    #print "X =", X, "type(X) =", type(X)
    import types
    #import openturns.typ, openturns.statistics
    Y = None
    if ( isinstance( X, typ.NumericalPoint ) ):
      #print "IDM : typ.NumericalPoint"
      Y = self._exec( X )
    elif ( isinstance( X, statistics.NumericalSample ) ):
      #print "IDM : typ.NumericalSample"
      Y = self._exec_sample( X )
    else :
      try:
        #print "IDM : try tuple -> NumericalPoint"
        pt = typ.NumericalPoint( X )
        #print "IDM : tuple -> NumericalPoint"
      except TypeError:
        try:
          #print "IDM : try tuple -> NumericalSample"
          ns = statistics.NumericalSample( X )
          #print "IDM : tuple -> NumericalSample"
        except TypeError:
          #print "IDM : type(X) =", type(X)
          #print "IDM : X =", X
          raise TypeError, "Expect a NumericalPoint or a NumericalSample as argument"
        else :
          Y = self._exec_sample( ns )
      else :
        Y = self._exec( pt )
    return Y

  def _exec(self, X) :
    if ( not hasattr( self, "f" ) ):
      raise RuntimeError, "You must define a method f(X) -> Y, where X and Y are NumericalPoint objects"
    import warnings
    warnings.warn("usage of method named 'f' is now deprecated. Rename it to '_exec' instead", DeprecationWarning )
    return self.f( X )

  def f(self, X) :
    raise RuntimeError, "You must define a method f(X) -> Y, where X and Y are NumericalPoint objects"

  def _exec_sample(self, X) :
    #print "IDM: _exec_sample"
    res = list()
    for point in X:
        res.append( self._exec( point ) )
    return res

%}

%template(NumericalMathFunctionImplementationTypedInterfaceObject)           OpenTURNS::Base::Common::TypedInterfaceObject<OpenTURNS::Base::Func::NumericalMathFunctionImplementation>;

// Deprecated
%ignore OpenTURNS::Base::Func::NumericalMathFunction::getInputNumericalPointDimension() const;
%ignore OpenTURNS::Base::Func::NumericalMathFunction::getOutputNumericalPointDimension() const;

%include NumericalMathFunction.hxx
//%copyctor NumericalMathFunction;

namespace OpenTURNS { namespace Base { namespace Func {

%extend NumericalMathFunction {

NumericalMathFunction(PyObject * pyObj)
{
 return new OpenTURNS::Base::Func::NumericalMathFunction( OpenTURNS::convert<OpenTURNS::_PyObject_,OpenTURNS::Base::Func::NumericalMathFunction>(pyObj) );
}

NumericalMathFunction(const NumericalMathFunction & other)
{
 return new OpenTURNS::Base::Func::NumericalMathFunction( other );
}

}

}}}
