//                                               -*- C++ -*-
/**
 *  @file  csv_parser_state.hxx
 *  @brief The definition of the internal state of the CSV parser
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: csv_parser_state.hxx 1866 2011-04-11 10:32:27Z schueller $
 */
#ifndef OPENTURNS_CSV_PARSER_STATE_HXX
#define OPENTURNS_CSV_PARSER_STATE_HXX

#include <string>
#include "NumericalPoint.hxx"
#include "Description.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Stat
    {

      struct CSVParserState
      {
        typedef OT::Base::Type::NumericalPoint                NumericalPoint;
        typedef OT::Base::Type::Description                   Description;

        enum FieldType { NotSet, RealField, StringField };

        FieldType                     Type;
        std::string                   St;
        double                        Val;
        bool                          errors;
        NumericalPoint                Point;
        Description                   Header;
        FileName                      theFileName;

        CSVParserState() : Type(NotSet),St(),Val(0.),errors(false),Point(),Header(),theFileName() {}

      }; /* end struct CSVParserState */


    } /* namespace Stat */
  } /* namespace Base */
} /* namespace OpenTURNS */


#endif /* OPENTURNS_CSV_PARSER_STATE_HXX */
