//                                               -*- C++ -*-
/**
 *  @file  Null.hxx
 *  @brief This class is a top-level class for the history mechanism of
 *  simulation algorithms. It delegates to its children the effective
 *  history strategy.
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: Null.hxx 1866 2011-04-11 10:32:27Z schueller $
 */
#ifndef OPENTURNS_NULL_HXX
#define OPENTURNS_NULL_HXX

#include "HistoryStrategyImplementation.hxx"
#include "NumericalSample.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Stat
    {

      /**
       * @class Null
       */

      class Null
        : public HistoryStrategyImplementation
      {

        CLASSNAME;

      public:

        typedef HistoryStrategyImplementation::NumericalPoint NumericalPoint;

        /** Constructor with parameters */
        explicit Null();

        /** Virtual constructor */
        virtual Null * clone() const;

        /** Store the point according to the strategy */
        void store(const NumericalPoint & point);

        /** String converter */
        String __repr__() const;

      protected:

      } ; /* class Null */

    } /* namespace Stat */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_NULL_HXX */
