//                                               -*- C++ -*-
/**
 *  @file  CovarianceMatrix.hxx
 *  @brief The class CovarianceMatrix implements covariance matrices
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-06-30 10:19:34 +0200 (Thu, 30 Jun 2011) $
 *  Id:      $Id: CovarianceMatrix.hxx 1972 2011-06-30 08:19:34Z schueller $
 */
#ifndef OPENTURNS_COVARIANCEMATRIX_HXX
#define OPENTURNS_COVARIANCEMATRIX_HXX

#include "OTprivate.hxx"
#include "SymmetricMatrix.hxx"
#include "SquareMatrix.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Stat
    {

      /**
       * @class CovarianceMatrix
       */

      class CovarianceMatrix
        : public Type::SymmetricMatrix
      {
        CLASSNAME;

      public:

        typedef Type::IdentityMatrix IdentityMatrix;
        typedef Type::SquareMatrix   SquareMatrix;

        /** Default constructor */
        CovarianceMatrix();

        /** Constructor with size */
        CovarianceMatrix(const UnsignedLong dim);

        /** Constructor from external collection */
        CovarianceMatrix(const UnsignedLong dim,
                         const Type::Collection<NumericalScalar> & elementsValues);


        /** String converter */
        virtual String __repr__() const;

        /** CovarianceMatrix transpose */
        CovarianceMatrix transpose () const ;

        /** CovarianceMatrix addition (must have the same dimensions) */
        CovarianceMatrix operator + (const CovarianceMatrix & m) const /* throw(InvalidDimensionException) */;
        using Type::SymmetricMatrix::operator +;

        /** CovarianceMatrix multiplication (must have consistent dimensions) */
        CovarianceMatrix operator * (const IdentityMatrix & m) const /* throw(InvalidDimensionException) */;
        using Type::SymmetricMatrix::operator *;

        /** Check if the matrix is SPD */
        virtual Bool isPositiveDefinite(const Bool keepIntact = true);

        /** Build the Cholesky factorization of the matrix */
        virtual SquareMatrix computeCholesky(const Bool keepIntact = true);

        /** Constructor with implementation */
        CovarianceMatrix(const Implementation & i);

      protected:



      private:
      }

        ; /* class CovarianceMatrix */



    } /* namespace Stat */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_COVARIANCEMATRIX_HXX */
