//                                               -*- C++ -*-
/**
 *  @file  TNCSpecificParameters.cxx
 *  @brief TNCSpecificParameters is an encapsulation of the TNC specific
 *         parameters.
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: TNCSpecificParameters.cxx 1866 2011-04-11 10:32:27Z schueller $
 */
#include <cstdlib>

#include "TNC.hxx"
#include "ResourceMap.hxx"
#include "PersistentObjectFactory.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Optim
    {

      CLASSNAMEINIT(TNCSpecificParameters);

      static Base::Common::Factory<TNCSpecificParameters> RegisteredFactory("TNCSpecificParameters");

      typedef Common::ResourceMap ResourceMap;

      const UnsignedLong    TNCSpecificParameters::DefaultMaxCGit  = ResourceMap::GetAsUnsignedLong( "TNC-DefaultMaxCGit" );
      const NumericalScalar TNCSpecificParameters::DefaultEta      = ResourceMap::GetAsNumericalScalar( "TNC-DefaultEta" );
      const NumericalScalar TNCSpecificParameters::DefaultStepmx   = ResourceMap::GetAsNumericalScalar( "TNC-DefaultStepmx" );
      const NumericalScalar TNCSpecificParameters::DefaultAccuracy = ResourceMap::GetAsNumericalScalar( "TNC-DefaultAccuracy" );
      const NumericalScalar TNCSpecificParameters::DefaultFmin     = ResourceMap::GetAsNumericalScalar( "TNC-DefaultFmin" );
      const NumericalScalar TNCSpecificParameters::DefaultRescale  = ResourceMap::GetAsNumericalScalar( "TNC-DefaultRescale" );

      /* Default with parameters */
      TNCSpecificParameters::TNCSpecificParameters():
        PersistentObject(),
        scale_(0),
        offset_(0),
        maxCGit_(DefaultMaxCGit),
        eta_(DefaultEta),
        stepmx_(DefaultStepmx),
        accuracy_(DefaultAccuracy),
        fmin_(DefaultFmin),
        rescale_(DefaultRescale)
      {
        // Nothing to do
      } /* SpecificParametersTNC */

      /* Parameters with parameters */
      TNCSpecificParameters::TNCSpecificParameters(const NumericalPoint & scale,
                                                   const NumericalPoint & offset,
                                                   const UnsignedLong    maxCGit,
                                                   const NumericalScalar eta,
                                                   const NumericalScalar stepmx,
                                                   const NumericalScalar accuracy,
                                                   const NumericalScalar fmin,
                                                   const NumericalScalar rescale):
        PersistentObject(),
        scale_(scale),
        offset_(offset),
        maxCGit_(maxCGit),
        eta_(eta),
        stepmx_(stepmx),
        accuracy_(accuracy),
        fmin_(fmin),
        rescale_(rescale)
      {
        // Nothing to do
      } /* SpecificParametersTNC */

      /* Virtual constructor */
      TNCSpecificParameters * TNCSpecificParameters::clone() const
      {
        return new TNCSpecificParameters(*this);
      }

      /* Scale accessor */
      TNC::NumericalPoint TNCSpecificParameters::getScale() const
      {
        return scale_;
      }

      void TNCSpecificParameters::setScale(const NumericalPoint & scale)
      {
        scale_ = scale;
      }

      /* Offset accessor */
      TNC::NumericalPoint TNCSpecificParameters::getOffset() const
      {
        return offset_;
      }

      void TNCSpecificParameters::setOffset(const NumericalPoint & offset)
      {
        offset_ = offset;
      }

      /* MaxCGit accessor */
      UnsignedLong TNCSpecificParameters::getMaxCGit() const
      {
        return maxCGit_;
      }

      void TNCSpecificParameters::setMaxCGit(const UnsignedLong maxCGit)
      {
        maxCGit_ = maxCGit;
      }

      /* Eta accessor */
      NumericalScalar TNCSpecificParameters::getEta() const
      {
        return eta_;
      }

      void TNCSpecificParameters::setEta(const NumericalScalar eta)
      {
        eta_ = eta;
      }

      /* Stepmx accessor */
      NumericalScalar TNCSpecificParameters::getStepmx() const
      {
        return stepmx_;
      }

      void TNCSpecificParameters::setStepmx(const NumericalScalar stepmx)
      {
        stepmx_ = stepmx;
      }

      /* Accuracy accessor */
      NumericalScalar TNCSpecificParameters::getAccuracy() const
      {
        return accuracy_;
      }

      void TNCSpecificParameters::setAccuracy(const NumericalScalar accuracy)
      {
        accuracy_ = accuracy;
      }

      /* Fmin accessor */
      NumericalScalar TNCSpecificParameters::getFmin() const
      {
        return fmin_;
      }

      void TNCSpecificParameters::setFmin(const NumericalScalar fmin)
      {
        fmin_ = fmin;
      }

      /* Rescale accessor */
      NumericalScalar TNCSpecificParameters::getRescale() const
      {
        return rescale_;
      }

      void TNCSpecificParameters::setRescale(const NumericalScalar rescale)
      {
        rescale_ = rescale;
      }

      /* String converter */
      String TNCSpecificParameters::__repr__() const
      {
        OSS oss;
        oss << "class=" << TNCSpecificParameters::GetClassName()
            << " scale=" << scale_
            << " offset=" << offset_
            << " maxCGit=" << maxCGit_
            << " eta=" << eta_
            << " stepmx=" << stepmx_
            << " accuracy=" << accuracy_
            << " fmin=" << fmin_
            << " rescale=" << rescale_;
        return oss;
      }

      /* Method save() stores the object through the StorageManager */
      void TNCSpecificParameters::save(StorageManager::Advocate & adv) const
      {
        Base::Common::PersistentObject::save(adv);
        adv.saveAttribute("scale_", scale_);
        adv.saveAttribute("offset_", offset_);
        adv.saveAttribute("maxCGit_", maxCGit_);
        adv.saveAttribute("eta_", eta_);
        adv.saveAttribute("stepmx_", stepmx_);
        adv.saveAttribute("accuracy_", accuracy_);
        adv.saveAttribute("fmin_", fmin_);
        adv.saveAttribute("rescale_", rescale_);
      }

      /* Method load() reloads the object from the StorageManager */
      void TNCSpecificParameters::load(StorageManager::Advocate & adv)
      {
        Base::Common::PersistentObject::load(adv);
        adv.loadAttribute("scale_", scale_);
        adv.loadAttribute("offset_", offset_);
        adv.loadAttribute("maxCGit_", maxCGit_);
        adv.loadAttribute("eta_", eta_);
        adv.loadAttribute("stepmx_", stepmx_);
        adv.loadAttribute("accuracy_", accuracy_);
        adv.loadAttribute("fmin_", fmin_);
        adv.loadAttribute("rescale_", rescale_);
      }

    } /* namespace Optim */
  } /* namespace Base */
} /* namespace OpenTURNS */



